/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature.subpackets;

import java.util.Date;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.pgpainless.algorithm.SignatureSubpacket;
import org.pgpainless.signature.subpackets.SignatureSubpacketsUtil;

public final class SignatureSubpacketGeneratorUtil {
    private SignatureSubpacketGeneratorUtil() {
    }

    public static void removeAllPacketsOfType(SignatureSubpacket subpacketType, PGPSignatureSubpacketGenerator subpacketGenerator) {
        SignatureSubpacketGeneratorUtil.removeAllPacketsOfType(subpacketType.getCode(), subpacketGenerator);
    }

    public static void removeAllPacketsOfType(int type, PGPSignatureSubpacketGenerator subpacketGenerator) {
        for (org.bouncycastle.bcpg.SignatureSubpacket subpacket : subpacketGenerator.getSubpackets(type)) {
            subpacketGenerator.removePacket(subpacket);
        }
    }

    public static void setSignatureCreationTimeInSubpacketGenerator(Date date, PGPSignatureSubpacketGenerator subpacketGenerator) {
        SignatureSubpacketGeneratorUtil.removeAllPacketsOfType(2, subpacketGenerator);
        subpacketGenerator.setSignatureCreationTime(false, date);
    }

    public static void setKeyExpirationDateInSubpacketGenerator(Date expirationDate, @Nonnull Date creationDate, PGPSignatureSubpacketGenerator subpacketGenerator) {
        SignatureSubpacketGeneratorUtil.removeAllPacketsOfType(9, subpacketGenerator);
        long secondsToExpire = SignatureSubpacketsUtil.getKeyLifetimeInSeconds(expirationDate, creationDate);
        subpacketGenerator.setKeyExpirationTime(true, secondsToExpire);
    }
}

