/*
 * Decompiled with CFR 0.152.
 */
package investigations;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.DocumentSignatureType;
import org.pgpainless.algorithm.StreamEncoding;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.encryption_signing.EncryptionOptions;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.encryption_signing.SigningOptions;
import org.pgpainless.key.protection.SecretKeyRingProtector;

public class CanonicalizedDataEncryptionTest {
    private static final String KEY = "-----BEGIN PGP PRIVATE KEY BLOCK-----\nVersion: PGPainless\nComment: 9AF4 29C4 C389 CC11 1739  98E9 9F8E E9C5 3AE5 C1A4\nComment: Test <test@vanitasvi.tae>\n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\nZd+AyZA+lkh8uI921Nnio2g70zVVSKEVaJcWTlkVyKge2iV/YkQ=\n=EyDf\n-----END PGP PRIVATE KEY BLOCK-----\n";
    String message = "Hello, World!\n";
    private static PGPSecretKeyRing secretKeys;
    private static PGPPublicKeyRing publicKeys;

    @BeforeAll
    public static void readKeys() throws IOException {
        secretKeys = PGPainless.readKeyRing().secretKeyRing(KEY);
        publicKeys = PGPainless.extractCertificate((PGPSecretKeyRing)secretKeys);
        System.out.println(PGPainless.asciiArmor((PGPKeyRing)secretKeys));
    }

    @Test
    public void binaryDataBinarySig() throws PGPException, IOException {
        String msg = this.encryptAndSign(this.message, DocumentSignatureType.BINARY_DOCUMENT, StreamEncoding.BINARY);
        OpenPgpMetadata metadata = this.decryptAndVerify(msg);
        if (!metadata.isVerified()) {
            System.out.println("Not verified. Session-Key: " + metadata.getSessionKey());
            System.out.println(msg);
            Assertions.fail();
        }
    }

    @Test
    public void binaryDataTextSig() throws PGPException, IOException {
        String msg = this.encryptAndSign(this.message, DocumentSignatureType.CANONICAL_TEXT_DOCUMENT, StreamEncoding.BINARY);
        OpenPgpMetadata metadata = this.decryptAndVerify(msg);
        if (!metadata.isVerified()) {
            System.out.println("Not verified. Session-Key: " + metadata.getSessionKey());
            System.out.println(msg);
            Assertions.fail();
        }
    }

    @Test
    @Disabled(value="Fails")
    public void textDataBinarySig() throws PGPException, IOException {
        String msg = this.encryptAndSign(this.message, DocumentSignatureType.BINARY_DOCUMENT, StreamEncoding.TEXT);
        OpenPgpMetadata metadata = this.decryptAndVerify(msg);
        if (!metadata.isVerified()) {
            System.out.println("Not verified. Session-Key: " + metadata.getSessionKey());
            System.out.println(msg);
            Assertions.fail();
        }
    }

    @Test
    public void textDataTextSig() throws PGPException, IOException {
        String msg = this.encryptAndSign(this.message, DocumentSignatureType.CANONICAL_TEXT_DOCUMENT, StreamEncoding.TEXT);
        OpenPgpMetadata metadata = this.decryptAndVerify(msg);
        if (!metadata.isVerified()) {
            System.out.println("Not verified. Session-Key: " + metadata.getSessionKey());
            System.out.println(msg);
            Assertions.fail();
        }
    }

    @Test
    @Disabled(value="Fails")
    public void utf8DataBinarySig() throws PGPException, IOException {
        String msg = this.encryptAndSign(this.message, DocumentSignatureType.BINARY_DOCUMENT, StreamEncoding.UTF8);
        OpenPgpMetadata metadata = this.decryptAndVerify(msg);
        if (!metadata.isVerified()) {
            System.out.println("Not verified. Session-Key: " + metadata.getSessionKey());
            System.out.println(msg);
            Assertions.fail();
        }
    }

    @Test
    public void utf8DataTextSig() throws PGPException, IOException {
        String msg = this.encryptAndSign(this.message, DocumentSignatureType.CANONICAL_TEXT_DOCUMENT, StreamEncoding.UTF8);
        OpenPgpMetadata metadata = this.decryptAndVerify(msg);
        if (!metadata.isVerified()) {
            System.out.println("Not verified. Session-Key: " + metadata.getSessionKey());
            System.out.println(msg);
            Assertions.fail();
        }
    }

    private String encryptAndSign(String message, DocumentSignatureType sigType, StreamEncoding dataFormat) throws PGPException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        EncryptionStream encryptionStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)out).withOptions(ProducerOptions.signAndEncrypt((EncryptionOptions)EncryptionOptions.encryptCommunications().addRecipient(publicKeys), (SigningOptions)SigningOptions.get().addInlineSignature(SecretKeyRingProtector.unprotectedKeys(), secretKeys, sigType)).setEncoding(dataFormat));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(message.getBytes(StandardCharsets.UTF_8));
        Streams.pipeAll((InputStream)inputStream, (OutputStream)encryptionStream);
        encryptionStream.close();
        String msg = out.toString();
        return msg;
    }

    private OpenPgpMetadata decryptAndVerify(String msg) throws PGPException, IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(msg.getBytes(StandardCharsets.UTF_8));
        DecryptionStream decryptionStream = PGPainless.decryptAndOrVerify().onInputStream((InputStream)in).withOptions(new ConsumerOptions().addDecryptionKey(secretKeys, SecretKeyRingProtector.unprotectedKeys()).addVerificationCert(publicKeys));
        Streams.drain((InputStream)decryptionStream);
        decryptionStream.close();
        return decryptionStream.getResult();
    }
}

