/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.DocumentSignatureType;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.algorithm.negotiation.HashAlgorithmNegotiator;
import org.pgpainless.exception.KeyCannotSignException;
import org.pgpainless.exception.KeyValidationError;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnlockSecretKey;
import org.pgpainless.policy.Policy;
import org.pgpainless.signature.subpackets.BaseSignatureSubpackets;
import org.pgpainless.signature.subpackets.SignatureSubpackets;
import org.pgpainless.signature.subpackets.SignatureSubpacketsHelper;

public final class SigningOptions {
    private final Map<SubkeyIdentifier, SigningMethod> signingMethods = new HashMap<SubkeyIdentifier, SigningMethod>();
    private HashAlgorithm hashAlgorithmOverride;

    public static SigningOptions get() {
        return new SigningOptions();
    }

    public SigningOptions addSignature(SecretKeyRingProtector signingKeyProtector, PGPSecretKeyRing signingKey) throws PGPException {
        return this.addInlineSignature(signingKeyProtector, signingKey, DocumentSignatureType.BINARY_DOCUMENT);
    }

    public SigningOptions addInlineSignatures(SecretKeyRingProtector secrectKeyDecryptor, Iterable<PGPSecretKeyRing> signingKeys, DocumentSignatureType signatureType) throws KeyValidationError, PGPException {
        for (PGPSecretKeyRing signingKey : signingKeys) {
            this.addInlineSignature(secrectKeyDecryptor, signingKey, signatureType);
        }
        return this;
    }

    public SigningOptions addInlineSignature(SecretKeyRingProtector secretKeyDecryptor, PGPSecretKeyRing secretKey, DocumentSignatureType signatureType) throws KeyValidationError, PGPException {
        return this.addInlineSignature(secretKeyDecryptor, secretKey, null, signatureType);
    }

    public SigningOptions addInlineSignature(SecretKeyRingProtector secretKeyDecryptor, PGPSecretKeyRing secretKey, String userId, DocumentSignatureType signatureType) throws KeyValidationError, PGPException {
        return this.addInlineSignature(secretKeyDecryptor, secretKey, userId, signatureType, null);
    }

    public SigningOptions addInlineSignature(SecretKeyRingProtector secretKeyDecryptor, PGPSecretKeyRing secretKey, String userId, DocumentSignatureType signatureType, @Nullable BaseSignatureSubpackets.Callback subpacketsCallback) throws KeyValidationError, PGPException {
        KeyRingInfo keyRingInfo = new KeyRingInfo((PGPKeyRing)secretKey, new Date());
        if (userId != null && !keyRingInfo.isUserIdValid(userId)) {
            throw new KeyValidationError(userId, keyRingInfo.getLatestUserIdCertification(userId), keyRingInfo.getUserIdRevocation(userId));
        }
        List<PGPPublicKey> signingPubKeys = keyRingInfo.getSigningSubkeys();
        if (signingPubKeys.isEmpty()) {
            throw new KeyCannotSignException("Key " + OpenPgpFingerprint.of((PGPKeyRing)secretKey) + " has no valid signing key.");
        }
        for (PGPPublicKey signingPubKey : signingPubKeys) {
            PGPSecretKey signingSecKey = secretKey.getSecretKey(signingPubKey.getKeyID());
            PGPPrivateKey signingSubkey = UnlockSecretKey.unlockSecretKey(signingSecKey, secretKeyDecryptor);
            Set<HashAlgorithm> hashAlgorithms = userId != null ? keyRingInfo.getPreferredHashAlgorithms(userId) : keyRingInfo.getPreferredHashAlgorithms(signingPubKey.getKeyID());
            HashAlgorithm hashAlgorithm = this.negotiateHashAlgorithm(hashAlgorithms, PGPainless.getPolicy());
            this.addSigningMethod(secretKey, signingSubkey, subpacketsCallback, hashAlgorithm, signatureType, false);
        }
        return this;
    }

    public SigningOptions addDetachedSignatures(SecretKeyRingProtector secretKeyDecryptor, Iterable<PGPSecretKeyRing> signingKeys, DocumentSignatureType signatureType) throws PGPException {
        for (PGPSecretKeyRing signingKey : signingKeys) {
            this.addDetachedSignature(secretKeyDecryptor, signingKey, signatureType);
        }
        return this;
    }

    public SigningOptions addDetachedSignature(SecretKeyRingProtector secretKeyDecryptor, PGPSecretKeyRing secretKey, DocumentSignatureType signatureType) throws PGPException {
        return this.addDetachedSignature(secretKeyDecryptor, secretKey, null, signatureType);
    }

    public SigningOptions addDetachedSignature(SecretKeyRingProtector secretKeyDecryptor, PGPSecretKeyRing secretKey, String userId, DocumentSignatureType signatureType) throws PGPException {
        return this.addDetachedSignature(secretKeyDecryptor, secretKey, userId, signatureType, null);
    }

    public SigningOptions addDetachedSignature(SecretKeyRingProtector secretKeyDecryptor, PGPSecretKeyRing secretKey, String userId, DocumentSignatureType signatureType, @Nullable BaseSignatureSubpackets.Callback subpacketCallback) throws PGPException {
        KeyRingInfo keyRingInfo = new KeyRingInfo((PGPKeyRing)secretKey, new Date());
        if (userId != null && !keyRingInfo.isUserIdValid(userId)) {
            throw new KeyValidationError(userId, keyRingInfo.getLatestUserIdCertification(userId), keyRingInfo.getUserIdRevocation(userId));
        }
        List<PGPPublicKey> signingPubKeys = keyRingInfo.getSigningSubkeys();
        if (signingPubKeys.isEmpty()) {
            throw new KeyCannotSignException("Key has no valid signing key.");
        }
        for (PGPPublicKey signingPubKey : signingPubKeys) {
            PGPSecretKey signingSecKey = secretKey.getSecretKey(signingPubKey.getKeyID());
            if (signingSecKey == null) {
                throw new PGPException("Missing secret key for signing key " + Long.toHexString(signingPubKey.getKeyID()));
            }
            PGPPrivateKey signingSubkey = signingSecKey.extractPrivateKey(secretKeyDecryptor.getDecryptor(signingPubKey.getKeyID()));
            Set<HashAlgorithm> hashAlgorithms = userId != null ? keyRingInfo.getPreferredHashAlgorithms(userId) : keyRingInfo.getPreferredHashAlgorithms(signingPubKey.getKeyID());
            HashAlgorithm hashAlgorithm = this.negotiateHashAlgorithm(hashAlgorithms, PGPainless.getPolicy());
            this.addSigningMethod(secretKey, signingSubkey, subpacketCallback, hashAlgorithm, signatureType, true);
        }
        return this;
    }

    private void addSigningMethod(PGPSecretKeyRing secretKey, PGPPrivateKey signingSubkey, @Nullable BaseSignatureSubpackets.Callback subpacketCallback, HashAlgorithm hashAlgorithm, DocumentSignatureType signatureType, boolean detached) throws PGPException {
        SubkeyIdentifier signingKeyIdentifier = new SubkeyIdentifier((PGPKeyRing)secretKey, signingSubkey.getKeyID());
        PGPSecretKey signingSecretKey = secretKey.getSecretKey(signingSubkey.getKeyID());
        PublicKeyAlgorithm publicKeyAlgorithm = PublicKeyAlgorithm.requireFromId(signingSecretKey.getPublicKey().getAlgorithm());
        int bitStrength = secretKey.getPublicKey().getBitStrength();
        if (!PGPainless.getPolicy().getPublicKeyAlgorithmPolicy().isAcceptable(publicKeyAlgorithm, bitStrength)) {
            throw new IllegalArgumentException("Public key algorithm policy violation: " + (Object)((Object)publicKeyAlgorithm) + " with bit strength " + bitStrength + " is not acceptable.");
        }
        PGPSignatureGenerator generator = this.createSignatureGenerator(signingSubkey, hashAlgorithm, signatureType);
        SignatureSubpackets hashedSubpackets = SignatureSubpackets.createHashedSubpackets(signingSecretKey.getPublicKey());
        SignatureSubpackets unhashedSubpackets = SignatureSubpackets.createEmptySubpackets();
        if (subpacketCallback != null) {
            subpacketCallback.modifyHashedSubpackets(hashedSubpackets);
            subpacketCallback.modifyUnhashedSubpackets(unhashedSubpackets);
        }
        generator.setHashedSubpackets(SignatureSubpacketsHelper.toVector(hashedSubpackets));
        generator.setUnhashedSubpackets(SignatureSubpacketsHelper.toVector(unhashedSubpackets));
        SigningMethod signingMethod = detached ? SigningMethod.detachedSignature(generator, hashAlgorithm) : SigningMethod.inlineSignature(generator, hashAlgorithm);
        this.signingMethods.put(signingKeyIdentifier, signingMethod);
    }

    private HashAlgorithm negotiateHashAlgorithm(Set<HashAlgorithm> preferences, Policy policy) {
        if (this.hashAlgorithmOverride != null) {
            return this.hashAlgorithmOverride;
        }
        return HashAlgorithmNegotiator.negotiateSignatureHashAlgorithm(policy).negotiateHashAlgorithm(preferences);
    }

    private PGPSignatureGenerator createSignatureGenerator(PGPPrivateKey privateKey, HashAlgorithm hashAlgorithm, DocumentSignatureType signatureType) throws PGPException {
        int publicKeyAlgorithm = privateKey.getPublicKeyPacket().getAlgorithm();
        PGPContentSignerBuilder signerBuilder = ImplementationFactory.getInstance().getPGPContentSignerBuilder(publicKeyAlgorithm, hashAlgorithm.getAlgorithmId());
        PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator(signerBuilder);
        signatureGenerator.init(signatureType.getSignatureType().getCode(), privateKey);
        return signatureGenerator;
    }

    Map<SubkeyIdentifier, SigningMethod> getSigningMethods() {
        return Collections.unmodifiableMap(this.signingMethods);
    }

    public SigningOptions overrideHashAlgorithm(HashAlgorithm hashAlgorithmOverride) {
        this.hashAlgorithmOverride = hashAlgorithmOverride;
        return this;
    }

    public HashAlgorithm getHashAlgorithmOverride() {
        return this.hashAlgorithmOverride;
    }

    public static final class SigningMethod {
        private final PGPSignatureGenerator signatureGenerator;
        private final boolean detached;
        private final HashAlgorithm hashAlgorithm;

        private SigningMethod(PGPSignatureGenerator signatureGenerator, boolean detached, HashAlgorithm hashAlgorithm) {
            this.signatureGenerator = signatureGenerator;
            this.detached = detached;
            this.hashAlgorithm = hashAlgorithm;
        }

        public static SigningMethod inlineSignature(PGPSignatureGenerator signatureGenerator, HashAlgorithm hashAlgorithm) {
            return new SigningMethod(signatureGenerator, false, hashAlgorithm);
        }

        public static SigningMethod detachedSignature(PGPSignatureGenerator signatureGenerator, HashAlgorithm hashAlgorithm) {
            return new SigningMethod(signatureGenerator, true, hashAlgorithm);
        }

        public boolean isDetached() {
            return this.detached;
        }

        public PGPSignatureGenerator getSignatureGenerator() {
            return this.signatureGenerator;
        }

        public HashAlgorithm getHashAlgorithm() {
            return this.hashAlgorithm;
        }
    }
}

