/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.util.io.Streams;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.util.ArmoredOutputStreamFactory;
import org.pgpainless.util.CRCingArmoredInputStreamWrapper;
import org.pgpainless.util.MultiMap;
import org.pgpainless.util.PGPUtilWrapper;
import org.pgpainless.util.Tuple;

public final class ArmorUtils {
    private static final Pattern PATTERN_MESSAGE_ID = Pattern.compile("^\\S{32}$");
    public static final String HEADER_COMMENT = "Comment";
    public static final String HEADER_VERSION = "Version";
    public static final String HEADER_MESSAGEID = "MessageID";
    public static final String HEADER_HASH = "Hash";
    public static final String HEADER_CHARSET = "Charset";

    private ArmorUtils() {
    }

    @Nonnull
    public static String toAsciiArmoredString(@Nonnull PGPSecretKey secretKey) throws IOException {
        MultiMap<String, String> header = ArmorUtils.keyToHeader(secretKey.getPublicKey());
        return ArmorUtils.toAsciiArmoredString(secretKey.getEncoded(), header);
    }

    @Nonnull
    public static String toAsciiArmoredString(@Nonnull PGPPublicKey publicKey) throws IOException {
        MultiMap<String, String> header = ArmorUtils.keyToHeader(publicKey);
        return ArmorUtils.toAsciiArmoredString(publicKey.getEncoded(), header);
    }

    @Nonnull
    public static String toAsciiArmoredString(@Nonnull PGPSecretKeyRing secretKeys) throws IOException {
        MultiMap<String, String> header = ArmorUtils.keysToHeader((PGPKeyRing)secretKeys);
        return ArmorUtils.toAsciiArmoredString(secretKeys.getEncoded(), header);
    }

    @Nonnull
    public static String toAsciiArmoredString(@Nonnull PGPPublicKeyRing publicKeys) throws IOException {
        MultiMap<String, String> header = ArmorUtils.keysToHeader((PGPKeyRing)publicKeys);
        return ArmorUtils.toAsciiArmoredString(publicKeys.getEncoded(), header);
    }

    @Nonnull
    public static String toAsciiArmoredString(@Nonnull PGPSecretKeyRingCollection secretKeyRings) throws IOException {
        StringBuilder sb = new StringBuilder();
        Iterator iterator = secretKeyRings.iterator();
        while (iterator.hasNext()) {
            PGPSecretKeyRing secretKeyRing = (PGPSecretKeyRing)iterator.next();
            sb.append(ArmorUtils.toAsciiArmoredString(secretKeyRing));
            if (!iterator.hasNext()) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    @Nonnull
    public static String toAsciiArmoredString(@Nonnull PGPPublicKeyRingCollection publicKeyRings) throws IOException {
        StringBuilder sb = new StringBuilder();
        Iterator iterator = publicKeyRings.iterator();
        while (iterator.hasNext()) {
            PGPPublicKeyRing publicKeyRing = (PGPPublicKeyRing)iterator.next();
            sb.append(ArmorUtils.toAsciiArmoredString(publicKeyRing));
            if (!iterator.hasNext()) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    @Nonnull
    public static String toAsciiArmoredString(@Nonnull byte[] bytes) throws IOException {
        return ArmorUtils.toAsciiArmoredString(bytes, null);
    }

    @Nonnull
    public static String toAsciiArmoredString(@Nonnull byte[] bytes, @Nullable MultiMap<String, String> additionalHeaderValues) throws IOException {
        return ArmorUtils.toAsciiArmoredString(new ByteArrayInputStream(bytes), additionalHeaderValues);
    }

    @Nonnull
    public static String toAsciiArmoredString(@Nonnull InputStream inputStream) throws IOException {
        return ArmorUtils.toAsciiArmoredString(inputStream, null);
    }

    @Nonnull
    public static String toAsciiArmoredString(@Nonnull InputStream inputStream, @Nullable MultiMap<String, String> additionalHeaderValues) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ArmoredOutputStream armor = ArmorUtils.toAsciiArmoredStream(out, additionalHeaderValues);
        Streams.pipeAll((InputStream)inputStream, (OutputStream)armor);
        armor.close();
        return out.toString();
    }

    @Nonnull
    public static ArmoredOutputStream toAsciiArmoredStream(@Nonnull PGPKeyRing keyRing, @Nonnull OutputStream outputStream) {
        MultiMap<String, String> header = ArmorUtils.keysToHeader(keyRing);
        return ArmorUtils.toAsciiArmoredStream(outputStream, header);
    }

    @Nonnull
    public static ArmoredOutputStream toAsciiArmoredStream(@Nonnull OutputStream outputStream, @Nullable MultiMap<String, String> header) {
        ArmoredOutputStream armoredOutputStream = ArmoredOutputStreamFactory.get(outputStream);
        if (header != null) {
            for (String headerKey : header.keySet()) {
                for (String headerValue : header.get(headerKey)) {
                    armoredOutputStream.addHeader(headerKey, headerValue);
                }
            }
        }
        return armoredOutputStream;
    }

    @Deprecated
    @Nonnull
    public static ArmoredOutputStream createArmoredOutputStreamFor(@Nonnull PGPKeyRing keyRing, @Nonnull OutputStream outputStream) {
        return ArmorUtils.toAsciiArmoredStream(keyRing, outputStream);
    }

    @Nonnull
    private static MultiMap<String, String> keysToHeader(@Nonnull PGPKeyRing keyRing) {
        PGPPublicKey publicKey = keyRing.getPublicKey();
        return ArmorUtils.keyToHeader(publicKey);
    }

    @Nonnull
    private static MultiMap<String, String> keyToHeader(@Nonnull PGPPublicKey publicKey) {
        MultiMap<String, String> header = new MultiMap<String, String>();
        OpenPgpFingerprint fingerprint = OpenPgpFingerprint.of(publicKey);
        header.put(HEADER_COMMENT, fingerprint.prettyPrint());
        ArmorUtils.setUserIdInfoOnHeader(header, publicKey);
        return header;
    }

    private static void setUserIdInfoOnHeader(@Nonnull MultiMap<String, String> header, @Nonnull PGPPublicKey publicKey) {
        Tuple<String, Integer> idCount = ArmorUtils.getPrimaryUserIdAndUserIdCount(publicKey);
        String primary = idCount.getA();
        int totalCount = idCount.getB();
        if (primary != null) {
            header.put(HEADER_COMMENT, primary);
        }
        if (totalCount == 2) {
            header.put(HEADER_COMMENT, "1 further identity");
        } else if (totalCount > 2) {
            header.put(HEADER_COMMENT, String.format("%d further identities", totalCount - 1));
        }
    }

    @Nonnull
    private static Tuple<String, Integer> getPrimaryUserIdAndUserIdCount(@Nonnull PGPPublicKey publicKey) {
        Iterator userIds = publicKey.getUserIDs();
        int countIdentities = 0;
        String first = null;
        String primary = null;
        block0: while (userIds.hasNext()) {
            ++countIdentities;
            String userId = (String)userIds.next();
            if (first == null) {
                first = userId;
            }
            if (primary != null) continue;
            Iterator signatures = publicKey.getSignaturesForID(userId);
            while (signatures.hasNext()) {
                PGPSignature signature = (PGPSignature)signatures.next();
                if (!signature.getHashedSubPackets().isPrimaryUserID()) continue;
                primary = userId;
                continue block0;
            }
        }
        String printed = primary != null ? primary : first;
        return new Tuple<String, Integer>(printed, countIdentities);
    }

    public static void addHashAlgorithmHeader(@Nonnull ArmoredOutputStream armor, @Nonnull HashAlgorithm hashAlgorithm) {
        armor.addHeader(HEADER_HASH, hashAlgorithm.getAlgorithmName());
    }

    public static void addCommentHeader(@Nonnull ArmoredOutputStream armor, @Nonnull String comment) {
        armor.addHeader(HEADER_COMMENT, comment);
    }

    public static void addMessageIdHeader(@Nonnull ArmoredOutputStream armor, @Nonnull String messageId) {
        if (!PATTERN_MESSAGE_ID.matcher(messageId).matches()) {
            throw new IllegalArgumentException("MessageIDs MUST consist of 32 printable characters.");
        }
        armor.addHeader(HEADER_MESSAGEID, messageId);
    }

    @Nonnull
    public static List<String> getCommentHeaderValues(@Nonnull ArmoredInputStream armor) {
        return ArmorUtils.getArmorHeaderValues(armor, HEADER_COMMENT);
    }

    @Nonnull
    public static List<String> getMessageIdHeaderValues(@Nonnull ArmoredInputStream armor) {
        return ArmorUtils.getArmorHeaderValues(armor, HEADER_MESSAGEID);
    }

    @Nonnull
    public static List<String> getHashHeaderValues(@Nonnull ArmoredInputStream armor) {
        return ArmorUtils.getArmorHeaderValues(armor, HEADER_HASH);
    }

    @Nonnull
    public static List<HashAlgorithm> getHashAlgorithms(@Nonnull ArmoredInputStream armor) {
        List<String> algorithmNames = ArmorUtils.getHashHeaderValues(armor);
        ArrayList<HashAlgorithm> algorithms = new ArrayList<HashAlgorithm>();
        for (String name : algorithmNames) {
            HashAlgorithm algorithm = HashAlgorithm.fromName(name);
            if (algorithm == null) continue;
            algorithms.add(algorithm);
        }
        return algorithms;
    }

    @Nonnull
    public static List<String> getVersionHeaderValues(@Nonnull ArmoredInputStream armor) {
        return ArmorUtils.getArmorHeaderValues(armor, HEADER_VERSION);
    }

    @Nonnull
    public static List<String> getCharsetHeaderValues(@Nonnull ArmoredInputStream armor) {
        return ArmorUtils.getArmorHeaderValues(armor, HEADER_CHARSET);
    }

    @Nonnull
    public static List<String> getArmorHeaderValues(@Nonnull ArmoredInputStream armor, @Nonnull String headerKey) {
        String[] header = armor.getArmorHeaders();
        String key = headerKey + ": ";
        ArrayList<String> values = new ArrayList<String>();
        for (String line : header) {
            if (!line.startsWith(key)) continue;
            values.add(line.substring(key.length()));
        }
        return values;
    }

    @Nonnull
    public static InputStream getDecoderStream(@Nonnull InputStream inputStream) throws IOException {
        BufferedInputStream buf = new BufferedInputStream(inputStream, 512);
        InputStream decoderStream = PGPUtilWrapper.getDecoderStream(buf);
        if (decoderStream instanceof BufferedInputStream) {
            return decoderStream;
        }
        decoderStream = CRCingArmoredInputStreamWrapper.possiblyWrap(decoderStream);
        decoderStream = PGPUtil.getDecoderStream((InputStream)decoderStream);
        return decoderStream;
    }
}

