/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.eddsa.EdDSACurve;
import org.pgpainless.key.generation.type.xdh.XDHSpec;
import org.pgpainless.util.TestAllImplementations;

public class IllegalKeyFlagsTest {
    @TestTemplate
    @ExtendWith(value={TestAllImplementations.class})
    public void testKeyCannotCarryFlagsTest() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> KeySpec.getBuilder((KeyType)KeyType.XDH((XDHSpec)XDHSpec._X25519), (KeyFlag)KeyFlag.SIGN_DATA, (KeyFlag[])new KeyFlag[0]));
        Assertions.assertThrows(IllegalArgumentException.class, () -> KeySpec.getBuilder((KeyType)KeyType.XDH((XDHSpec)XDHSpec._X25519), (KeyFlag)KeyFlag.CERTIFY_OTHER, (KeyFlag[])new KeyFlag[0]));
        Assertions.assertThrows(IllegalArgumentException.class, () -> KeySpec.getBuilder((KeyType)KeyType.XDH((XDHSpec)XDHSpec._X25519), (KeyFlag)KeyFlag.AUTHENTICATION, (KeyFlag[])new KeyFlag[0]));
        Assertions.assertThrows(IllegalArgumentException.class, () -> KeySpec.getBuilder((KeyType)KeyType.EDDSA((EdDSACurve)EdDSACurve._Ed25519), (KeyFlag)KeyFlag.ENCRYPT_COMMS, (KeyFlag[])new KeyFlag[0]));
        Assertions.assertThrows(IllegalArgumentException.class, () -> KeySpec.getBuilder((KeyType)KeyType.EDDSA((EdDSACurve)EdDSACurve._Ed25519), (KeyFlag)KeyFlag.ENCRYPT_STORAGE, (KeyFlag[])new KeyFlag[0]));
    }
}

