/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.modification;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.JUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.pgpainless.PGPainless;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;
import org.pgpainless.util.DateUtil;
import org.pgpainless.util.TestAllImplementations;

public class ChangeExpirationTest {
    private final OpenPgpV4Fingerprint subKeyFingerprint = new OpenPgpV4Fingerprint("F73FDE6439ABE210B1AF4EDD273EF7A0C749807B");

    @TestTemplate
    @ExtendWith(value={TestAllImplementations.class})
    public void setExpirationDateAndThenUnsetIt_OnPrimaryKey() throws PGPException, IOException, InterruptedException {
        PGPSecretKeyRing secretKeys = TestKeys.getEmilSecretKeyRing();
        KeyRingInfo sInfo = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertNull((Object)sInfo.getPrimaryKeyExpirationDate());
        Assertions.assertNull((Object)sInfo.getSubkeyExpirationDate((OpenPgpFingerprint)this.subKeyFingerprint));
        Date date = DateUtil.parseUTCDate((String)"2020-11-27 16:10:32 UTC");
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).setExpirationDate(date, (SecretKeyRingProtector)new UnprotectedKeysProtector()).done();
        sInfo = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertNotNull((Object)sInfo.getPrimaryKeyExpirationDate());
        Assertions.assertEquals((long)date.getTime(), (long)sInfo.getPrimaryKeyExpirationDate().getTime());
        Assertions.assertNull((Object)sInfo.getSubkeyExpirationDate((OpenPgpFingerprint)this.subKeyFingerprint));
        Thread.sleep(1100L);
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).setExpirationDate(null, (SecretKeyRingProtector)new UnprotectedKeysProtector()).done();
        sInfo = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertNull((Object)sInfo.getPrimaryKeyExpirationDate());
        Assertions.assertNull((Object)sInfo.getSubkeyExpirationDate((OpenPgpFingerprint)this.subKeyFingerprint));
    }

    @TestTemplate
    @ExtendWith(value={TestAllImplementations.class})
    public void setExpirationDateAndThenUnsetIt_OnSubkey() throws PGPException, IOException, InterruptedException {
        PGPSecretKeyRing secretKeys = TestKeys.getEmilSecretKeyRing();
        KeyRingInfo sInfo = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertNull((Object)sInfo.getPrimaryKeyExpirationDate());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, 5);
        Date expiration = calendar.getTime();
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).setExpirationDate(expiration, (SecretKeyRingProtector)new UnprotectedKeysProtector()).done();
        sInfo = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertNotNull((Object)sInfo.getPrimaryKeyExpirationDate());
        JUtils.assertDateEquals(expiration, sInfo.getPrimaryKeyExpirationDate());
        Thread.sleep(1100L);
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).setExpirationDate(null, (SecretKeyRingProtector)new UnprotectedKeysProtector()).done();
        sInfo = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertNull((Object)sInfo.getPrimaryKeyExpirationDate());
    }

    @TestTemplate
    @ExtendWith(value={TestAllImplementations.class})
    public void testExtremeExpirationDates() throws PGPException, IOException {
        PGPSecretKeyRing secretKeys = TestKeys.getEmilSecretKeyRing();
        SecretKeyRingProtector protector = SecretKeyRingProtector.unprotectedKeys();
        Date farAwayExpiration = DateUtil.parseUTCDate((String)"2199-01-01 00:00:00 UTC");
        PGPSecretKeyRing finalKeys = secretKeys;
        Assertions.assertThrows(IllegalArgumentException.class, () -> PGPainless.modifyKeyRing((PGPSecretKeyRing)finalKeys).setExpirationDate(farAwayExpiration, protector).done());
        Date notSoFarAwayExpiration = DateUtil.parseUTCDate((String)"2100-01-01 00:00:00 UTC");
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).setExpirationDate(notSoFarAwayExpiration, protector).done();
        Date actualExpiration = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys).getPrimaryKeyExpirationDate();
        JUtils.assertDateEquals(notSoFarAwayExpiration, actualExpiration);
    }
}

