/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.modification;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Date;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.pgpainless.PGPainless;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;
import org.pgpainless.util.TestAllImplementations;

public class OldSignatureSubpacketsArePreservedOnNewSig {
    @TestTemplate
    @ExtendWith(value={TestAllImplementations.class})
    public void verifyOldSignatureSubpacketsArePreservedOnNewExpirationDateSig() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException, InterruptedException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().simpleEcKeyRing("Alice <alice@wonderland.lit>");
        PGPSignature oldSignature = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys).getLatestUserIdCertification("Alice <alice@wonderland.lit>");
        PGPSignatureSubpacketVector oldPackets = oldSignature.getHashedSubPackets();
        Assertions.assertEquals((long)0L, (long)oldPackets.getKeyExpirationTime());
        Thread.sleep(1000L);
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.add(5, 5);
        Date expiration = calendar.getTime();
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).setExpirationDate(expiration, (SecretKeyRingProtector)new UnprotectedKeysProtector()).done();
        PGPSignature newSignature = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys).getLatestUserIdCertification("Alice <alice@wonderland.lit>");
        PGPSignatureSubpacketVector newPackets = newSignature.getHashedSubPackets();
        Assertions.assertNotEquals((long)0L, (long)newPackets.getKeyExpirationTime());
        Assertions.assertArrayEquals((int[])oldPackets.getPreferredHashAlgorithms(), (int[])newPackets.getPreferredHashAlgorithms());
    }
}

