/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.modification;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import org.bouncycastle.bcpg.sig.IssuerFingerprint;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.EncryptionPurpose;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.modification.secretkeyring.SecretKeyRingEditorInterface;
import org.pgpainless.key.protection.PasswordBasedSecretKeyRingProtector;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.util.RevocationAttributes;
import org.pgpainless.signature.SignatureUtils;
import org.pgpainless.signature.subpackets.RevocationSignatureSubpackets;
import org.pgpainless.signature.subpackets.SignatureSubpacketsUtil;
import org.pgpainless.util.Passphrase;
import org.pgpainless.util.TestAllImplementations;

public class RevokeSubKeyTest {
    @TestTemplate
    @ExtendWith(value={TestAllImplementations.class})
    public void revokeSukeyTest() throws IOException, PGPException {
        PGPSecretKeyRing secretKeys = TestKeys.getCryptieSecretKeyRing();
        Iterator keysIterator = secretKeys.iterator();
        PGPSecretKey primaryKey = (PGPSecretKey)keysIterator.next();
        PGPSecretKey subKey = (PGPSecretKey)keysIterator.next();
        Assertions.assertFalse((boolean)subKey.getPublicKey().hasRevocation());
        PasswordBasedSecretKeyRingProtector protector = PasswordBasedSecretKeyRingProtector.forKey((PGPKeyRing)secretKeys, (Passphrase)Passphrase.fromPassword((String)"password123"));
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).revokeSubKey((OpenPgpFingerprint)new OpenPgpV4Fingerprint(subKey), (SecretKeyRingProtector)protector).done();
        keysIterator = secretKeys.iterator();
        primaryKey = (PGPSecretKey)keysIterator.next();
        subKey = (PGPSecretKey)keysIterator.next();
        Assertions.assertTrue((boolean)subKey.getPublicKey().hasRevocation());
    }

    @TestTemplate
    @ExtendWith(value={TestAllImplementations.class})
    public void detachedRevokeSubkeyTest() throws IOException, PGPException {
        PGPSecretKeyRing secretKeys = TestKeys.getCryptieSecretKeyRing();
        OpenPgpV4Fingerprint fingerprint = new OpenPgpV4Fingerprint(secretKeys);
        PasswordBasedSecretKeyRingProtector protector = PasswordBasedSecretKeyRingProtector.forKey((PGPKeyRing)secretKeys, (Passphrase)Passphrase.fromPassword((String)"password123"));
        PGPSignature revocationCertificate = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).createRevocationCertificate((OpenPgpFingerprint)fingerprint, (SecretKeyRingProtector)protector, RevocationAttributes.createKeyRevocation().withReason(RevocationAttributes.Reason.KEY_RETIRED).withDescription("Key no longer used."));
        PGPPublicKey publicKey = secretKeys.getPublicKey();
        Assertions.assertFalse((boolean)publicKey.hasRevocation());
        publicKey = PGPPublicKey.addCertification((PGPPublicKey)publicKey, (PGPSignature)revocationCertificate);
        Assertions.assertTrue((boolean)publicKey.hasRevocation());
    }

    @TestTemplate
    @ExtendWith(value={TestAllImplementations.class})
    public void testRevocationSignatureTypeCorrect() throws IOException, PGPException {
        PGPSecretKeyRing secretKeys = TestKeys.getCryptieSecretKeyRing();
        Iterator keysIterator = secretKeys.getPublicKeys();
        PGPPublicKey primaryKey = (PGPPublicKey)keysIterator.next();
        PGPPublicKey subKey = (PGPPublicKey)keysIterator.next();
        PasswordBasedSecretKeyRingProtector protector = PasswordBasedSecretKeyRingProtector.forKey((PGPKeyRing)secretKeys, (Passphrase)Passphrase.fromPassword((String)"password123"));
        SecretKeyRingEditorInterface editor = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys);
        PGPSignature keyRevocation = editor.createRevocationCertificate(primaryKey.getKeyID(), (SecretKeyRingProtector)protector, (RevocationAttributes)null);
        PGPSignature subkeyRevocation = editor.createRevocationCertificate(subKey.getKeyID(), (SecretKeyRingProtector)protector, (RevocationAttributes)null);
        Assertions.assertEquals((int)SignatureType.KEY_REVOCATION.getCode(), (int)keyRevocation.getSignatureType());
        Assertions.assertEquals((int)SignatureType.SUBKEY_REVOCATION.getCode(), (int)subkeyRevocation.getSignatureType());
    }

    @Test
    public void testThrowsIfRevocationReasonTypeMismatch() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> RevocationAttributes.createKeyRevocation().withReason(RevocationAttributes.Reason.USER_ID_NO_LONGER_VALID));
        Assertions.assertThrows(IllegalArgumentException.class, () -> RevocationAttributes.createCertificateRevocation().withReason(RevocationAttributes.Reason.KEY_SUPERSEDED));
        Assertions.assertThrows(IllegalArgumentException.class, () -> RevocationAttributes.createCertificateRevocation().withReason(RevocationAttributes.Reason.KEY_COMPROMISED));
        Assertions.assertThrows(IllegalArgumentException.class, () -> RevocationAttributes.createCertificateRevocation().withReason(RevocationAttributes.Reason.KEY_RETIRED));
    }

    @Test
    public void testReasonToString() {
        RevocationAttributes.Reason reason = RevocationAttributes.Reason.KEY_COMPROMISED;
        Assertions.assertEquals((Object)"2 - KEY_COMPROMISED", (Object)reason.toString());
    }

    @Test
    public void inspectSubpacketsOnDefaultRevocationSignature() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing("Alice");
        SecretKeyRingProtector protector = SecretKeyRingProtector.unprotectedKeys();
        PGPPublicKey encryptionSubkey = (PGPPublicKey)PGPainless.inspectKeyRing((PGPKeyRing)secretKeys).getEncryptionSubkeys(EncryptionPurpose.ANY).get(0);
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).revokeSubKey(encryptionSubkey.getKeyID(), protector).done();
        encryptionSubkey = secretKeys.getPublicKey(encryptionSubkey.getKeyID());
        PGPSignature revocation = (PGPSignature)encryptionSubkey.getSignaturesOfType(SignatureType.SUBKEY_REVOCATION.getCode()).next();
        Assertions.assertNotNull((Object)revocation);
        Assertions.assertArrayEquals((byte[])secretKeys.getPublicKey().getFingerprint(), (byte[])revocation.getHashedSubPackets().getIssuerFingerprint().getFingerprint());
        Assertions.assertEquals((long)secretKeys.getPublicKey().getKeyID(), (long)revocation.getHashedSubPackets().getIssuerKeyID());
        Assertions.assertNull((Object)SignatureSubpacketsUtil.getRevocationReason((PGPSignature)revocation));
        Assertions.assertTrue((boolean)SignatureUtils.isHardRevocation((PGPSignature)revocation));
    }

    @Test
    public void inspectSubpacketsOnModifiedRevocationSignature() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing("Alice");
        SecretKeyRingProtector protector = SecretKeyRingProtector.unprotectedKeys();
        PGPPublicKey encryptionSubkey = (PGPPublicKey)PGPainless.inspectKeyRing((PGPKeyRing)secretKeys).getEncryptionSubkeys(EncryptionPurpose.ANY).get(0);
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).revokeSubKey(encryptionSubkey.getKeyID(), protector, new RevocationSignatureSubpackets.Callback(){

            public void modifyHashedSubpackets(RevocationSignatureSubpackets hashedSubpackets) {
                hashedSubpackets.setRevocationReason(RevocationAttributes.createKeyRevocation().withReason(RevocationAttributes.Reason.KEY_RETIRED).withDescription("I have a new Key."));
                hashedSubpackets.setIssuerFingerprint((IssuerFingerprint)null);
            }
        }).done();
        encryptionSubkey = secretKeys.getPublicKey(encryptionSubkey.getKeyID());
        PGPSignature revocation = (PGPSignature)encryptionSubkey.getSignaturesOfType(SignatureType.SUBKEY_REVOCATION.getCode()).next();
        Assertions.assertNotNull((Object)revocation);
        Assertions.assertNull((Object)revocation.getHashedSubPackets().getIssuerFingerprint());
        Assertions.assertEquals((long)secretKeys.getPublicKey().getKeyID(), (long)revocation.getHashedSubPackets().getIssuerKeyID());
        Assertions.assertNotNull((Object)SignatureSubpacketsUtil.getRevocationReason((PGPSignature)revocation));
        Assertions.assertFalse((boolean)SignatureUtils.isHardRevocation((PGPSignature)revocation));
    }
}

