/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util.selection.keyring;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.key.TestKeys;
import org.pgpainless.util.MultiMap;
import org.pgpainless.util.selection.keyring.impl.ExactUserId;

public class KeyRingsFromCollectionTest {
    @Test
    public void selectSecretKeyRingFromSecretKeyRingCollectionTest() throws IOException, PGPException {
        PGPSecretKeyRing emil = TestKeys.getEmilSecretKeyRing();
        PGPSecretKeyRing juliet = TestKeys.getJulietSecretKeyRing();
        PGPSecretKeyRingCollection collection = new PGPSecretKeyRingCollection(Arrays.asList(emil, juliet));
        ExactUserId.SecRingSelectionStrategy strategy = new ExactUserId.SecRingSelectionStrategy();
        Set secretKeyRings = strategy.selectKeyRingsFromCollection((Object)"xmpp:juliet@capulet.lit", collection);
        Assertions.assertEquals((int)1, (int)secretKeyRings.size());
        Assertions.assertEquals((long)juliet.getPublicKey().getKeyID(), (long)((PGPSecretKeyRing)secretKeyRings.iterator().next()).getPublicKey().getKeyID());
    }

    @Test
    public void selectSecretKeyRingMapFromSecretKeyRingCollectionMapTest() throws IOException, PGPException {
        PGPSecretKeyRing emil = TestKeys.getEmilSecretKeyRing();
        PGPSecretKeyRing juliet = TestKeys.getJulietSecretKeyRing();
        MultiMap map = new MultiMap();
        PGPSecretKeyRingCollection julietCollection = new PGPSecretKeyRingCollection(Arrays.asList(emil, juliet));
        map.put((Object)"xmpp:juliet@capulet.lit", (Object)julietCollection);
        PGPSecretKeyRingCollection emilCollection = new PGPSecretKeyRingCollection(Collections.singletonList(emil));
        map.put((Object)"<emil@email.user>", (Object)emilCollection);
        Assertions.assertEquals((int)2, (int)julietCollection.size());
        map.put((Object)"invalidId", (Object)emilCollection);
        ExactUserId.SecRingSelectionStrategy strategy = new ExactUserId.SecRingSelectionStrategy();
        MultiMap selected = strategy.selectKeyRingsFromCollections(map);
        Assertions.assertEquals((int)1, (int)selected.get((Object)"xmpp:juliet@capulet.lit").size());
        Assertions.assertEquals((int)1, (int)selected.get((Object)"<emil@email.user>").size());
        Assertions.assertNull((Object)selected.get((Object)"invalidId"));
    }

    @Test
    public void selectPublicKeyRingFromPublicKeyRingCollectionTest() throws IOException, PGPException {
        PGPPublicKeyRing emil = TestKeys.getEmilPublicKeyRing();
        PGPPublicKeyRing juliet = TestKeys.getJulietPublicKeyRing();
        PGPPublicKeyRingCollection collection = new PGPPublicKeyRingCollection(Arrays.asList(emil, juliet));
        ExactUserId.PubRingSelectionStrategy strategy = new ExactUserId.PubRingSelectionStrategy();
        Set publicKeyRings = strategy.selectKeyRingsFromCollection((Object)"xmpp:juliet@capulet.lit", collection);
        Assertions.assertEquals((int)1, (int)publicKeyRings.size());
        Assertions.assertEquals((long)juliet.getPublicKey().getKeyID(), (long)((PGPPublicKeyRing)publicKeyRings.iterator().next()).getPublicKey().getKeyID());
    }

    @Test
    public void selectPublicKeyRingMapFromPublicKeyRingCollectionMapTest() throws IOException, PGPException {
        PGPPublicKeyRing emil = TestKeys.getEmilPublicKeyRing();
        PGPPublicKeyRing juliet = TestKeys.getJulietPublicKeyRing();
        MultiMap map = new MultiMap();
        PGPPublicKeyRingCollection julietCollection = new PGPPublicKeyRingCollection(Arrays.asList(emil, juliet));
        map.put((Object)"xmpp:juliet@capulet.lit", (Object)julietCollection);
        PGPPublicKeyRingCollection emilCollection = new PGPPublicKeyRingCollection(Collections.singletonList(emil));
        map.put((Object)"<emil@email.user>", (Object)emilCollection);
        Assertions.assertEquals((int)2, (int)julietCollection.size());
        map.put((Object)"invalidId", (Object)emilCollection);
        ExactUserId.PubRingSelectionStrategy strategy = new ExactUserId.PubRingSelectionStrategy();
        MultiMap selected = strategy.selectKeyRingsFromCollections(map);
        Assertions.assertEquals((int)1, (int)selected.get((Object)"xmpp:juliet@capulet.lit").size());
        Assertions.assertEquals((int)1, (int)selected.get((Object)"<emil@email.user>").size());
        Assertions.assertNull((Object)selected.get((Object)"invalidId"));
    }
}

