/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature.subpackets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.bcpg.sig.Exportable;
import org.bouncycastle.bcpg.sig.Features;
import org.bouncycastle.bcpg.sig.IntendedRecipientFingerprint;
import org.bouncycastle.bcpg.sig.IssuerFingerprint;
import org.bouncycastle.bcpg.sig.IssuerKeyID;
import org.bouncycastle.bcpg.sig.KeyExpirationTime;
import org.bouncycastle.bcpg.sig.KeyFlags;
import org.bouncycastle.bcpg.sig.NotationData;
import org.bouncycastle.bcpg.sig.PreferredAlgorithms;
import org.bouncycastle.bcpg.sig.PrimaryUserID;
import org.bouncycastle.bcpg.sig.Revocable;
import org.bouncycastle.bcpg.sig.RevocationKey;
import org.bouncycastle.bcpg.sig.RevocationReason;
import org.bouncycastle.bcpg.sig.SignatureCreationTime;
import org.bouncycastle.bcpg.sig.SignatureExpirationTime;
import org.bouncycastle.bcpg.sig.SignatureTarget;
import org.bouncycastle.bcpg.sig.SignerUserID;
import org.bouncycastle.bcpg.sig.TrustSignature;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.Feature;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.algorithm.SignatureSubpacket;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.signature.SignatureUtils;

public final class SignatureSubpacketsUtil {
    private SignatureSubpacketsUtil() {
    }

    @Nullable
    public static IssuerFingerprint getIssuerFingerprint(PGPSignature signature) {
        return (IssuerFingerprint)SignatureSubpacketsUtil.hashedOrUnhashed(signature, SignatureSubpacket.issuerFingerprint);
    }

    @Nullable
    public static OpenPgpFingerprint getIssuerFingerprintAsOpenPgpFingerprint(PGPSignature signature) {
        IssuerFingerprint subpacket = SignatureSubpacketsUtil.getIssuerFingerprint(signature);
        if (subpacket == null) {
            return null;
        }
        OpenPgpV4Fingerprint fingerprint = null;
        if (subpacket.getKeyVersion() == 4) {
            fingerprint = new OpenPgpV4Fingerprint(subpacket.getFingerprint());
        }
        return fingerprint;
    }

    @Nullable
    public static IssuerKeyID getIssuerKeyId(PGPSignature signature) {
        return (IssuerKeyID)SignatureSubpacketsUtil.hashedOrUnhashed(signature, SignatureSubpacket.issuerKeyId);
    }

    @Nullable
    public static Long getIssuerKeyIdAsLong(PGPSignature signature) {
        IssuerKeyID keyID = SignatureSubpacketsUtil.getIssuerKeyId(signature);
        if (keyID == null) {
            return null;
        }
        return keyID.getKeyID();
    }

    @Nullable
    public static RevocationReason getRevocationReason(PGPSignature signature) {
        return (RevocationReason)SignatureSubpacketsUtil.hashed(signature, SignatureSubpacket.revocationReason);
    }

    @Nullable
    public static SignatureCreationTime getSignatureCreationTime(PGPSignature signature) {
        return (SignatureCreationTime)SignatureSubpacketsUtil.hashed(signature, SignatureSubpacket.signatureCreationTime);
    }

    @Nullable
    public static SignatureExpirationTime getSignatureExpirationTime(PGPSignature signature) {
        return (SignatureExpirationTime)SignatureSubpacketsUtil.hashed(signature, SignatureSubpacket.signatureExpirationTime);
    }

    @Nullable
    public static Date getSignatureExpirationTimeAsDate(PGPSignature signature) {
        SignatureExpirationTime subpacket = SignatureSubpacketsUtil.getSignatureExpirationTime(signature);
        if (subpacket == null) {
            return null;
        }
        return SignatureUtils.datePlusSeconds(signature.getCreationTime(), subpacket.getTime());
    }

    @Nullable
    public static KeyExpirationTime getKeyExpirationTime(PGPSignature signature) {
        return (KeyExpirationTime)SignatureSubpacketsUtil.hashed(signature, SignatureSubpacket.keyExpirationTime);
    }

    @Nullable
    public static Date getKeyExpirationTimeAsDate(PGPSignature signature, PGPPublicKey signingKey) {
        if (signature.getKeyID() != signingKey.getKeyID()) {
            throw new IllegalArgumentException("Provided key (" + Long.toHexString(signingKey.getKeyID()) + ") did not create the signature (" + Long.toHexString(signature.getKeyID()) + ")");
        }
        KeyExpirationTime subpacket = SignatureSubpacketsUtil.getKeyExpirationTime(signature);
        if (subpacket == null) {
            return null;
        }
        return SignatureUtils.datePlusSeconds(signingKey.getCreationTime(), subpacket.getTime());
    }

    public static long getKeyLifetimeInSeconds(@Nullable Date expirationDate, @Nonnull Date creationDate) {
        long secondsToExpire = 0L;
        if (expirationDate != null) {
            if (creationDate.after(expirationDate)) {
                throw new IllegalArgumentException("Key MUST NOT expire before being created. (creation: " + creationDate + ", expiration: " + expirationDate + ")");
            }
            secondsToExpire = (expirationDate.getTime() - creationDate.getTime()) / 1000L;
        }
        return secondsToExpire;
    }

    @Nullable
    public static Revocable getRevocable(PGPSignature signature) {
        return (Revocable)SignatureSubpacketsUtil.hashed(signature, SignatureSubpacket.revocable);
    }

    @Nullable
    public static PreferredAlgorithms getPreferredSymmetricAlgorithms(PGPSignature signature) {
        return (PreferredAlgorithms)SignatureSubpacketsUtil.hashed(signature, SignatureSubpacket.preferredSymmetricAlgorithms);
    }

    @Nonnull
    public static Set<SymmetricKeyAlgorithm> parsePreferredSymmetricKeyAlgorithms(PGPSignature signature) {
        LinkedHashSet<SymmetricKeyAlgorithm> algorithms = new LinkedHashSet<SymmetricKeyAlgorithm>();
        PreferredAlgorithms preferences = SignatureSubpacketsUtil.getPreferredSymmetricAlgorithms(signature);
        if (preferences != null) {
            for (int code : preferences.getPreferences()) {
                SymmetricKeyAlgorithm algorithm = SymmetricKeyAlgorithm.fromId(code);
                if (algorithm == null) continue;
                algorithms.add(algorithm);
            }
        }
        return algorithms;
    }

    @Nullable
    public static PreferredAlgorithms getPreferredHashAlgorithms(PGPSignature signature) {
        return (PreferredAlgorithms)SignatureSubpacketsUtil.hashed(signature, SignatureSubpacket.preferredHashAlgorithms);
    }

    @Nonnull
    public static Set<HashAlgorithm> parsePreferredHashAlgorithms(PGPSignature signature) {
        LinkedHashSet<HashAlgorithm> algorithms = new LinkedHashSet<HashAlgorithm>();
        PreferredAlgorithms preferences = SignatureSubpacketsUtil.getPreferredHashAlgorithms(signature);
        if (preferences != null) {
            for (int code : preferences.getPreferences()) {
                HashAlgorithm algorithm = HashAlgorithm.fromId(code);
                if (algorithm == null) continue;
                algorithms.add(algorithm);
            }
        }
        return algorithms;
    }

    @Nullable
    public static PreferredAlgorithms getPreferredCompressionAlgorithms(PGPSignature signature) {
        return (PreferredAlgorithms)SignatureSubpacketsUtil.hashed(signature, SignatureSubpacket.preferredCompressionAlgorithms);
    }

    @Nonnull
    public static Set<CompressionAlgorithm> parsePreferredCompressionAlgorithms(PGPSignature signature) {
        LinkedHashSet<CompressionAlgorithm> algorithms = new LinkedHashSet<CompressionAlgorithm>();
        PreferredAlgorithms preferences = SignatureSubpacketsUtil.getPreferredCompressionAlgorithms(signature);
        if (preferences != null) {
            for (int code : preferences.getPreferences()) {
                CompressionAlgorithm algorithm = CompressionAlgorithm.fromId(code);
                if (algorithm == null) continue;
                algorithms.add(algorithm);
            }
        }
        return algorithms;
    }

    @Nullable
    public static PrimaryUserID getPrimaryUserId(PGPSignature signature) {
        return (PrimaryUserID)SignatureSubpacketsUtil.hashed(signature, SignatureSubpacket.primaryUserId);
    }

    @Nullable
    public static KeyFlags getKeyFlags(PGPSignature signature) {
        return (KeyFlags)SignatureSubpacketsUtil.hashed(signature, SignatureSubpacket.keyFlags);
    }

    @Nullable
    public static List<KeyFlag> parseKeyFlags(@Nullable PGPSignature signature) {
        if (signature == null) {
            return null;
        }
        KeyFlags keyFlags = SignatureSubpacketsUtil.getKeyFlags(signature);
        if (keyFlags == null) {
            return null;
        }
        return KeyFlag.fromBitmask(keyFlags.getFlags());
    }

    @Nullable
    public static Features getFeatures(PGPSignature signature) {
        return (Features)SignatureSubpacketsUtil.hashed(signature, SignatureSubpacket.features);
    }

    @Nullable
    public static Set<Feature> parseFeatures(PGPSignature signature) {
        Features features = SignatureSubpacketsUtil.getFeatures(signature);
        if (features == null) {
            return null;
        }
        return new LinkedHashSet<Feature>(Feature.fromBitmask(features.getData()[0]));
    }

    @Nullable
    public static SignatureTarget getSignatureTarget(PGPSignature signature) {
        return (SignatureTarget)SignatureSubpacketsUtil.hashedOrUnhashed(signature, SignatureSubpacket.signatureTarget);
    }

    @Nonnull
    public static List<NotationData> getHashedNotationData(PGPSignature signature) {
        NotationData[] notations = signature.getHashedSubPackets().getNotationDataOccurrences();
        return Arrays.asList(notations);
    }

    @Nonnull
    public static List<NotationData> getHashedNotationData(PGPSignature signature, String notationName) {
        List<NotationData> allNotations = SignatureSubpacketsUtil.getHashedNotationData(signature);
        ArrayList<NotationData> withName = new ArrayList<NotationData>();
        for (NotationData data : allNotations) {
            if (!data.getNotationName().equals(notationName)) continue;
            withName.add(data);
        }
        return withName;
    }

    @Nonnull
    public static List<NotationData> getUnhashedNotationData(PGPSignature signature) {
        NotationData[] notations = signature.getUnhashedSubPackets().getNotationDataOccurrences();
        return Arrays.asList(notations);
    }

    @Nonnull
    public static List<NotationData> getUnhashedNotationData(PGPSignature signature, String notationName) {
        List<NotationData> allNotations = SignatureSubpacketsUtil.getUnhashedNotationData(signature);
        ArrayList<NotationData> withName = new ArrayList<NotationData>();
        for (NotationData data : allNotations) {
            if (!data.getNotationName().equals(notationName)) continue;
            withName.add(data);
        }
        return withName;
    }

    @Nullable
    public static RevocationKey getRevocationKey(PGPSignature signature) {
        return (RevocationKey)SignatureSubpacketsUtil.hashed(signature, SignatureSubpacket.revocationKey);
    }

    @Nullable
    public static SignerUserID getSignerUserID(PGPSignature signature) {
        return (SignerUserID)SignatureSubpacketsUtil.hashed(signature, SignatureSubpacket.signerUserId);
    }

    @Nonnull
    public static List<IntendedRecipientFingerprint> getIntendedRecipientFingerprints(PGPSignature signature) {
        org.bouncycastle.bcpg.SignatureSubpacket[] subpackets = signature.getHashedSubPackets().getSubpackets(SignatureSubpacket.intendedRecipientFingerprint.getCode());
        ArrayList<IntendedRecipientFingerprint> intendedRecipients = new ArrayList<IntendedRecipientFingerprint>(subpackets.length);
        for (org.bouncycastle.bcpg.SignatureSubpacket subpacket : subpackets) {
            intendedRecipients.add((IntendedRecipientFingerprint)subpacket);
        }
        return intendedRecipients;
    }

    @Nullable
    public static PGPSignatureList getEmbeddedSignature(PGPSignature signature) throws PGPException {
        PGPSignatureList hashed = signature.getHashedSubPackets().getEmbeddedSignatures();
        if (!hashed.isEmpty()) {
            return hashed;
        }
        return signature.getUnhashedSubPackets().getEmbeddedSignatures();
    }

    @Nullable
    public static Exportable getExportableCertification(PGPSignature signature) {
        return (Exportable)SignatureSubpacketsUtil.hashed(signature, SignatureSubpacket.exportableCertification);
    }

    @Nullable
    public static TrustSignature getTrustSignature(PGPSignature signature) {
        return (TrustSignature)SignatureSubpacketsUtil.hashed(signature, SignatureSubpacket.trustSignature);
    }

    @Nullable
    private static <P extends org.bouncycastle.bcpg.SignatureSubpacket> P hashed(PGPSignature signature, SignatureSubpacket type) {
        return SignatureSubpacketsUtil.getSignatureSubpacket(signature.getHashedSubPackets(), type);
    }

    @Nullable
    private static <P extends org.bouncycastle.bcpg.SignatureSubpacket> P unhashed(PGPSignature signature, SignatureSubpacket type) {
        return SignatureSubpacketsUtil.getSignatureSubpacket(signature.getUnhashedSubPackets(), type);
    }

    @Nullable
    private static <P extends org.bouncycastle.bcpg.SignatureSubpacket> P hashedOrUnhashed(PGPSignature signature, SignatureSubpacket type) {
        P hashedSubpacket = SignatureSubpacketsUtil.hashed(signature, type);
        return hashedSubpacket != null ? hashedSubpacket : SignatureSubpacketsUtil.unhashed(signature, type);
    }

    @Nullable
    public static <P extends org.bouncycastle.bcpg.SignatureSubpacket> P getSignatureSubpacket(PGPSignatureSubpacketVector vector, SignatureSubpacket type) {
        if (vector == null) {
            return null;
        }
        org.bouncycastle.bcpg.SignatureSubpacket[] allPackets = vector.getSubpackets(type.getCode());
        if (allPackets.length == 0) {
            return null;
        }
        org.bouncycastle.bcpg.SignatureSubpacket last = allPackets[allPackets.length - 1];
        return (P)last;
    }

    public static void assureKeyCanCarryFlags(KeyType type, KeyFlag ... flags) {
        int mask = KeyFlag.toBitmask(flags);
        if (!type.canCertify() && KeyFlag.hasKeyFlag(mask, KeyFlag.CERTIFY_OTHER)) {
            throw new IllegalArgumentException("KeyType " + type.getName() + " cannot carry key flag CERTIFY_OTHER.");
        }
        if (!type.canSign() && KeyFlag.hasKeyFlag(mask, KeyFlag.SIGN_DATA)) {
            throw new IllegalArgumentException("KeyType " + type.getName() + " cannot carry key flag SIGN_DATA.");
        }
        if (!type.canEncryptCommunication() && KeyFlag.hasKeyFlag(mask, KeyFlag.ENCRYPT_COMMS)) {
            throw new IllegalArgumentException("KeyType " + type.getName() + " cannot carry key flag ENCRYPT_COMMS.");
        }
        if (!type.canEncryptStorage() && KeyFlag.hasKeyFlag(mask, KeyFlag.ENCRYPT_STORAGE)) {
            throw new IllegalArgumentException("KeyType " + type.getName() + " cannot carry key flag ENCRYPT_STORAGE.");
        }
        if (!type.canAuthenticate() && KeyFlag.hasKeyFlag(mask, KeyFlag.AUTHENTICATION)) {
            throw new IllegalArgumentException("KeyType " + type.getName() + " cannot carry key flag AUTHENTICATION.");
        }
    }

    public static void assureKeyCanCarryFlags(PublicKeyAlgorithm algorithm, KeyFlag ... flags) {
        int mask = KeyFlag.toBitmask(flags);
        if (!algorithm.isSigningCapable() && KeyFlag.hasKeyFlag(mask, KeyFlag.CERTIFY_OTHER)) {
            throw new IllegalArgumentException("Algorithm " + (Object)((Object)algorithm) + " cannot be used with key flag CERTIFY_OTHER.");
        }
        if (!algorithm.isSigningCapable() && KeyFlag.hasKeyFlag(mask, KeyFlag.SIGN_DATA)) {
            throw new IllegalArgumentException("Algorithm " + (Object)((Object)algorithm) + " cannot be used with key flag SIGN_DATA.");
        }
        if (!algorithm.isEncryptionCapable() && KeyFlag.hasKeyFlag(mask, KeyFlag.ENCRYPT_COMMS)) {
            throw new IllegalArgumentException("Algorithm " + (Object)((Object)algorithm) + " cannot be used with key flag ENCRYPT_COMMS.");
        }
        if (!algorithm.isEncryptionCapable() && KeyFlag.hasKeyFlag(mask, KeyFlag.ENCRYPT_STORAGE)) {
            throw new IllegalArgumentException("Algorithm " + (Object)((Object)algorithm) + " cannot be used with key flag ENCRYPT_STORAGE.");
        }
        if (!algorithm.isSigningCapable() && KeyFlag.hasKeyFlag(mask, KeyFlag.AUTHENTICATION)) {
            throw new IllegalArgumentException("Algorithm " + (Object)((Object)algorithm) + " cannot be used with key flag AUTHENTICATION.");
        }
    }
}

