/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.modification;

import java.io.IOException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.key.util.RevocationAttributes;

public class RevocationCertificateTest {
    @Test
    public void createRevocationCertificateTest() throws PGPException, IOException {
        PGPSecretKeyRing secretKeys = TestKeys.getEmilSecretKeyRing();
        PGPSignature revocation = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).createRevocationCertificate(SecretKeyRingProtector.unprotectedKeys(), RevocationAttributes.createKeyRevocation().withReason(RevocationAttributes.Reason.KEY_RETIRED).withoutDescription());
        Assertions.assertNotNull((Object)revocation);
        Assertions.assertTrue((boolean)PGPainless.inspectKeyRing((PGPKeyRing)secretKeys).isKeyValidlyBound(secretKeys.getPublicKey().getKeyID()));
        PGPSecretKeyRing revokedKey = KeyRingUtils.keysPlusSecretKey((PGPSecretKeyRing)secretKeys, (PGPSecretKey)KeyRingUtils.secretKeyPlusSignature((PGPSecretKey)secretKeys.getSecretKey(), (PGPSignature)revocation));
        Assertions.assertFalse((boolean)PGPainless.inspectKeyRing((PGPKeyRing)revokedKey).isKeyValidlyBound(secretKeys.getPublicKey().getKeyID()));
    }
}

