/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.algorithm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.NoSuchElementException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.algorithm.RevocationState;
import org.pgpainless.algorithm.RevocationStateType;
import org.pgpainless.util.DateUtil;

public class RevocationStateTest {
    @Test
    public void testNotRevoked() {
        RevocationState state = RevocationState.notRevoked();
        Assertions.assertEquals((Object)RevocationStateType.notRevoked, (Object)state.getType());
        Assertions.assertTrue((boolean)state.isNotRevoked());
        Assertions.assertFalse((boolean)state.isHardRevocation());
        Assertions.assertFalse((boolean)state.isSoftRevocation());
        Assertions.assertThrows(NoSuchElementException.class, () -> ((RevocationState)state).getDate());
        Assertions.assertEquals((Object)"notRevoked", (Object)state.toString());
    }

    @Test
    public void testHardRevoked() {
        RevocationState state = RevocationState.hardRevoked();
        Assertions.assertEquals((Object)RevocationStateType.hardRevoked, (Object)state.getType());
        Assertions.assertTrue((boolean)state.isHardRevocation());
        Assertions.assertFalse((boolean)state.isSoftRevocation());
        Assertions.assertFalse((boolean)state.isNotRevoked());
        Assertions.assertThrows(NoSuchElementException.class, () -> ((RevocationState)state).getDate());
        Assertions.assertEquals((Object)"hardRevoked", (Object)state.toString());
    }

    @Test
    public void testSoftRevoked() {
        Date date = DateUtil.parseUTCDate((String)"2022-08-03 18:26:35 UTC");
        Assertions.assertNotNull((Object)date);
        RevocationState state = RevocationState.softRevoked((Date)date);
        Assertions.assertEquals((Object)RevocationStateType.softRevoked, (Object)state.getType());
        Assertions.assertTrue((boolean)state.isSoftRevocation());
        Assertions.assertFalse((boolean)state.isHardRevocation());
        Assertions.assertFalse((boolean)state.isNotRevoked());
        Assertions.assertEquals((Object)date, (Object)state.getDate());
        Assertions.assertEquals((Object)"softRevoked (2022-08-03 18:26:35 UTC)", (Object)state.toString());
    }

    @Test
    public void testSoftRevokedNullDateThrows() {
        Assertions.assertThrows(NullPointerException.class, () -> RevocationState.softRevoked(null));
    }

    @Test
    public void orderTest() {
        Assertions.assertEquals((Object)RevocationState.notRevoked(), (Object)RevocationState.notRevoked());
        Assertions.assertEquals((Object)RevocationState.hardRevoked(), (Object)RevocationState.hardRevoked());
        Date now = new Date();
        Assertions.assertEquals((Object)RevocationState.softRevoked((Date)now), (Object)RevocationState.softRevoked((Date)now));
        Assertions.assertEquals((int)0, (int)RevocationState.notRevoked().compareTo(RevocationState.notRevoked()));
        Assertions.assertEquals((int)0, (int)RevocationState.hardRevoked().compareTo(RevocationState.hardRevoked()));
        Assertions.assertTrue((RevocationState.hardRevoked().compareTo(RevocationState.notRevoked()) > 0 ? 1 : 0) != 0);
        ArrayList<RevocationState> states = new ArrayList<RevocationState>();
        RevocationState earlySoft = RevocationState.softRevoked((Date)DateUtil.parseUTCDate((String)"2000-05-12 10:44:01 UTC"));
        RevocationState laterSoft = RevocationState.softRevoked((Date)DateUtil.parseUTCDate((String)"2022-08-03 18:26:35 UTC"));
        RevocationState hard = RevocationState.hardRevoked();
        RevocationState not = RevocationState.notRevoked();
        RevocationState not2 = RevocationState.notRevoked();
        states.add(laterSoft);
        states.add(not);
        states.add(not2);
        states.add(hard);
        states.add(earlySoft);
        Collections.shuffle(states);
        Collections.sort(states);
        Assertions.assertEquals(states, Arrays.asList(not, not2, laterSoft, earlySoft, hard));
    }
}

