/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.util.SessionKey;

public class TestDecryptionOfMessageWithoutESKUsingSessionKey {
    private static final String encryptedMessageWithSKESK = "-----BEGIN PGP MESSAGE-----\nVersion: PGPainless\n\njA0ECQMCc7jNEadAMZJg0j8BNtJwO2PLoRdG+VynivV7XpHp2Nw/S489vksUKct6\n7CYTFpVTzB4IcJwmUGMmre/N1KMTznEBzy3Txa1QVBc=\n=3M8l\n-----END PGP MESSAGE-----";
    private static final String encryptedMessageWithoutESK = "-----BEGIN PGP MESSAGE-----\nVersion: PGPainless\n\n0j8BNtJwO2PLoRdG+VynivV7XpHp2Nw/S489vksUKct67CYTFpVTzB4IcJwmUGMm\nre/N1KMTznEBzy3Txa1QVBc=\n=t+pk\n-----END PGP MESSAGE-----";
    private static final SessionKey sessionKey = new SessionKey(PGPSessionKey.fromAsciiRepresentation((String)"9:26be99bc478520fbc8ab8fb84991dace4b82cfb9b00f7d05c051d69b8cea8a7f"));

    @Test
    public void decryptMessageWithSKESK() throws PGPException, IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(encryptedMessageWithSKESK.getBytes(StandardCharsets.UTF_8));
        DecryptionStream decryptionStream = PGPainless.decryptAndOrVerify().onInputStream((InputStream)in).withOptions(ConsumerOptions.get().setSessionKey(sessionKey));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)decryptionStream, (OutputStream)out);
        decryptionStream.close();
        Assertions.assertEquals((Object)"Hello, World!\n", (Object)out.toString());
    }

    @Disabled(value="Bug in BC 172. See https://github.com/bcgit/bc-java/pull/1228")
    @Test
    public void decryptMessageWithoutSKESK() throws PGPException, IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(encryptedMessageWithoutESK.getBytes(StandardCharsets.UTF_8));
        DecryptionStream decryptionStream = PGPainless.decryptAndOrVerify().onInputStream((InputStream)in).withOptions(ConsumerOptions.get().setSessionKey(sessionKey));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)decryptionStream, (OutputStream)out);
        decryptionStream.close();
        Assertions.assertEquals((Object)"Hello, World!\n", (Object)out.toString());
    }
}

