/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.encryption_signing.EncryptionOptions;
import org.pgpainless.exception.KeyException;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.eddsa.EdDSACurve;
import org.pgpainless.key.generation.type.xdh.XDHSpec;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.util.Passphrase;

public class EncryptionOptionsTest {
    private static PGPSecretKeyRing secretKeys;
    private static PGPPublicKeyRing publicKeys;
    private static SubkeyIdentifier primaryKey;
    private static SubkeyIdentifier encryptComms;
    private static SubkeyIdentifier encryptStorage;

    @BeforeAll
    public static void generateKey() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        secretKeys = PGPainless.buildKeyRing().setPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.EDDSA((EdDSACurve)EdDSACurve._Ed25519), (KeyFlag)KeyFlag.CERTIFY_OTHER, (KeyFlag[])new KeyFlag[0]).build()).addSubkey(KeySpec.getBuilder((KeyType)KeyType.XDH((XDHSpec)XDHSpec._X25519), (KeyFlag)KeyFlag.ENCRYPT_COMMS, (KeyFlag[])new KeyFlag[0]).build()).addSubkey(KeySpec.getBuilder((KeyType)KeyType.XDH((XDHSpec)XDHSpec._X25519), (KeyFlag)KeyFlag.ENCRYPT_STORAGE, (KeyFlag[])new KeyFlag[0]).build()).addUserId("test@pgpainless.org").build();
        publicKeys = KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)secretKeys);
        Iterator iterator = publicKeys.iterator();
        primaryKey = new SubkeyIdentifier((PGPKeyRing)publicKeys, ((PGPPublicKey)iterator.next()).getKeyID());
        encryptComms = new SubkeyIdentifier((PGPKeyRing)publicKeys, ((PGPPublicKey)iterator.next()).getKeyID());
        encryptStorage = new SubkeyIdentifier((PGPKeyRing)publicKeys, ((PGPPublicKey)iterator.next()).getKeyID());
    }

    @Test
    public void testOverrideEncryptionAlgorithmFailsForNULL() {
        EncryptionOptions options = new EncryptionOptions();
        Assertions.assertNull((Object)options.getEncryptionAlgorithmOverride());
        Assertions.assertThrows(IllegalArgumentException.class, () -> options.overrideEncryptionAlgorithm(SymmetricKeyAlgorithm.NULL));
        Assertions.assertNull((Object)options.getEncryptionAlgorithmOverride());
    }

    @Test
    public void testOverrideEncryptionOptions() {
        EncryptionOptions options = new EncryptionOptions();
        Assertions.assertNull((Object)options.getEncryptionAlgorithmOverride());
        options.overrideEncryptionAlgorithm(SymmetricKeyAlgorithm.AES_128);
        Assertions.assertEquals((Object)SymmetricKeyAlgorithm.AES_128, (Object)options.getEncryptionAlgorithmOverride());
    }

    @Test
    public void testAddRecipients_EncryptCommunications() {
        EncryptionOptions options = EncryptionOptions.encryptCommunications();
        options.addRecipient(publicKeys);
        Set encryptionKeys = options.getEncryptionKeyIdentifiers();
        Assertions.assertEquals((int)1, (int)encryptionKeys.size());
        Assertions.assertEquals((Object)encryptComms, encryptionKeys.iterator().next());
    }

    @Test
    public void testAddRecipients_EncryptDataAtRest() {
        EncryptionOptions options = EncryptionOptions.encryptDataAtRest();
        options.addRecipient(publicKeys);
        Set encryptionKeys = options.getEncryptionKeyIdentifiers();
        Assertions.assertEquals((int)1, (int)encryptionKeys.size());
        Assertions.assertEquals((Object)encryptStorage, encryptionKeys.iterator().next());
    }

    @Test
    public void testAddRecipients_AllKeys() {
        EncryptionOptions options = new EncryptionOptions();
        options.addRecipient(publicKeys, EncryptionOptions.encryptToAllCapableSubkeys());
        Set encryptionKeys = options.getEncryptionKeyIdentifiers();
        Assertions.assertEquals((int)2, (int)encryptionKeys.size());
        Assertions.assertTrue((boolean)encryptionKeys.contains(encryptComms));
        Assertions.assertTrue((boolean)encryptionKeys.contains(encryptStorage));
    }

    @Test
    public void testAddEmptyRecipientsFails() {
        EncryptionOptions options = new EncryptionOptions();
        Assertions.assertThrows(IllegalArgumentException.class, () -> options.addRecipients(Collections.emptyList()));
        Assertions.assertThrows(IllegalArgumentException.class, () -> options.addRecipients(Collections.emptyList(), encryptionCapableKeys -> encryptionCapableKeys));
    }

    @Test
    public void testAddEmptyPassphraseFails() {
        EncryptionOptions options = new EncryptionOptions();
        Assertions.assertThrows(IllegalArgumentException.class, () -> options.addPassphrase(Passphrase.emptyPassphrase()));
    }

    @Test
    public void testAddRecipient_KeyWithoutEncryptionKeyFails() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        EncryptionOptions options = new EncryptionOptions();
        PGPSecretKeyRing secretKeys = ((KeyRingBuilder)PGPainless.buildKeyRing().setPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.EDDSA((EdDSACurve)EdDSACurve._Ed25519), (KeyFlag)KeyFlag.CERTIFY_OTHER, (KeyFlag[])new KeyFlag[]{KeyFlag.SIGN_DATA}))).addUserId("test@pgpainless.org").build();
        PGPPublicKeyRing publicKeys = KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)secretKeys);
        Assertions.assertThrows(KeyException.UnacceptableEncryptionKeyException.class, () -> options.addRecipient(publicKeys));
    }

    @Test
    public void testEncryptionKeySelectionStrategyEmpty_ThrowsAssertionError() {
        EncryptionOptions options = new EncryptionOptions();
        Assertions.assertThrows(KeyException.UnacceptableEncryptionKeyException.class, () -> options.addRecipient(publicKeys, new EncryptionOptions.EncryptionKeySelector(){

            public List<PGPPublicKey> selectEncryptionSubkeys(List<PGPPublicKey> encryptionCapableKeys) {
                return Collections.emptyList();
            }
        }));
        Assertions.assertThrows(KeyException.UnacceptableEncryptionKeyException.class, () -> options.addRecipient(publicKeys, "test@pgpainless.org", new EncryptionOptions.EncryptionKeySelector(){

            public List<PGPPublicKey> selectEncryptionSubkeys(List<PGPPublicKey> encryptionCapableKeys) {
                return Collections.emptyList();
            }
        }));
    }

    @Test
    public void testAddRecipients_PGPPublicKeyRingCollection() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        PGPPublicKeyRing secondKeyRing = KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)PGPainless.generateKeyRing().modernKeyRing("other@pgpainless.org"));
        PGPPublicKeyRingCollection collection = new PGPPublicKeyRingCollection(Arrays.asList(publicKeys, secondKeyRing));
        EncryptionOptions options = new EncryptionOptions();
        options.addRecipients((Iterable)collection, EncryptionOptions.encryptToFirstSubkey());
        Assertions.assertEquals((int)2, (int)options.getEncryptionKeyIdentifiers().size());
    }

    @Test
    public void testAddRecipient_withValidUserId() {
        EncryptionOptions options = new EncryptionOptions();
        options.addRecipient(publicKeys, "test@pgpainless.org", EncryptionOptions.encryptToFirstSubkey());
        Assertions.assertEquals((int)1, (int)options.getEncryptionMethods().size());
    }

    @Test
    public void testAddRecipient_withInvalidUserId() {
        EncryptionOptions options = new EncryptionOptions();
        Assertions.assertThrows(KeyException.UnboundUserIdException.class, () -> options.addRecipient(publicKeys, "invalid@user.id"));
    }
}

