/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.key.util.UserId;

public class UserIdTest {
    @Test
    public void throwForNullName() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> UserId.newBuilder().withName(null));
    }

    @Test
    public void throwForNullComment() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> UserId.newBuilder().withComment(null));
    }

    @Test
    public void throwForNullEmail() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> UserId.newBuilder().withEmail(null));
    }

    @Test
    public void testFormatOnlyName() {
        Assertions.assertEquals((Object)"Juliet Capulet", (Object)UserId.newBuilder().withName("Juliet Capulet").build().toString());
    }

    @Test
    public void testFormatNameAndComment() {
        Assertions.assertEquals((Object)"Juliet Capulet (from the play)", (Object)UserId.newBuilder().withName("Juliet Capulet").withComment("from the play").noEmail().build().toString());
    }

    @Test
    public void testFormatNameCommentAndMail() {
        Assertions.assertEquals((Object)"Juliet Capulet (from the play) <juliet@capulet.lit>", (Object)UserId.newBuilder().withName("Juliet Capulet").withComment("from the play").withEmail("juliet@capulet.lit").build().toString());
    }

    @Test
    public void testFormatNameAndEmail() {
        Assertions.assertEquals((Object)"Juliet Capulet <juliet@capulet.lit>", (Object)UserId.newBuilder().withName("Juliet Capulet").noComment().withEmail("juliet@capulet.lit").build().toString());
    }

    @Test
    public void throwIfOnlyEmailEmailNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> UserId.onlyEmail(null));
    }

    @Test
    public void testNameAndEmail() {
        UserId userId = UserId.nameAndEmail((String)"Maurice Moss", (String)"moss.m@reynholm.co.uk");
        Assertions.assertEquals((Object)"Maurice Moss <moss.m@reynholm.co.uk>", (Object)userId.toString());
    }

    @Test
    void testBuilderWithName() {
        UserId userId = UserId.newBuilder().withName("John Smith").build();
        Assertions.assertEquals((Object)"John Smith", (Object)userId.getName());
        Assertions.assertNull((Object)userId.getComment());
        Assertions.assertNull((Object)userId.getEmail());
    }

    @Test
    void testBuilderWithComment() {
        UserId userId = UserId.newBuilder().withComment("Sales Dept.").build();
        Assertions.assertNull((Object)userId.getName());
        Assertions.assertEquals((Object)"Sales Dept.", (Object)userId.getComment());
        Assertions.assertNull((Object)userId.getEmail());
    }

    @Test
    void testBuilderWithEmail() {
        UserId userId = UserId.newBuilder().withEmail("john.smith@example.com").build();
        Assertions.assertNull((Object)userId.getName());
        Assertions.assertNull((Object)userId.getComment());
        Assertions.assertEquals((Object)"john.smith@example.com", (Object)userId.getEmail());
    }

    @Test
    void testBuilderWithAll() {
        UserId userId = UserId.newBuilder().withEmail("john.smith@example.com").withName("John Smith").withEmail("john.smith@example.com").withComment("Sales Dept.").build();
        Assertions.assertEquals((Object)"John Smith", (Object)userId.getName());
        Assertions.assertEquals((Object)"Sales Dept.", (Object)userId.getComment());
        Assertions.assertEquals((Object)"john.smith@example.com", (Object)userId.getEmail());
    }

    @Test
    void testBuilderNoName() {
        UserId.Builder builder = UserId.newBuilder().withEmail("john.smith@example.com").withName("John Smith").withComment("Sales Dept.").build().toBuilder();
        UserId userId = builder.noName().build();
        Assertions.assertNull((Object)userId.getName());
        Assertions.assertEquals((Object)"Sales Dept.", (Object)userId.getComment());
        Assertions.assertEquals((Object)"john.smith@example.com", (Object)userId.getEmail());
    }

    @Test
    void testBuilderNoComment() {
        UserId.Builder builder = UserId.newBuilder().withEmail("john.smith@example.com").withName("John Smith").withComment("Sales Dept.").build().toBuilder();
        UserId userId = builder.noComment().build();
        Assertions.assertEquals((Object)"John Smith", (Object)userId.getName());
        Assertions.assertNull((Object)userId.getComment());
        Assertions.assertEquals((Object)"john.smith@example.com", (Object)userId.getEmail());
    }

    @Test
    void testBuilderNoEmail() {
        UserId.Builder builder = UserId.newBuilder().withEmail("john.smith@example.com").withName("John Smith").withComment("Sales Dept.").build().toBuilder();
        UserId userId = builder.noEmail().build();
        Assertions.assertEquals((Object)"John Smith", (Object)userId.getName());
        Assertions.assertEquals((Object)"Sales Dept.", (Object)userId.getComment());
        Assertions.assertNull((Object)userId.getEmail());
    }

    @Test
    void testEmailOnlyFormatting() {
        UserId userId = UserId.onlyEmail((String)"john.smith@example.com");
        Assertions.assertEquals((Object)"john.smith@example.com", (Object)userId.toString());
    }

    @Test
    void testEmptyNameAndValidEmailFormatting() {
        UserId userId = UserId.nameAndEmail((String)"", (String)"john.smith@example.com");
        Assertions.assertEquals((Object)"john.smith@example.com", (Object)userId.toString());
        Assertions.assertEquals((Object)"john.smith@example.com", (Object)userId.asString(false));
        Assertions.assertEquals((Object)"john.smith@example.com", (Object)userId.asString(true));
    }

    @Test
    void testEmptyNameAndEmptyCommentAndValidEmailFormatting() {
        UserId userId = UserId.newBuilder().withComment("").withName("").withEmail("john.smith@example.com").build();
        Assertions.assertEquals((Object)" () <john.smith@example.com>", (Object)userId.toString());
        Assertions.assertEquals((Object)" () <john.smith@example.com>", (Object)userId.asString(false));
        Assertions.assertEquals((Object)"john.smith@example.com", (Object)userId.asString(true));
    }

    @Test
    void testEqualsWithDifferentCaseEmails() {
        String name = "John Smith";
        String comment = "Sales Dept.";
        String email = "john.smith@example.com";
        String upperEmail = "john.smith@example.com".toUpperCase();
        UserId userId1 = UserId.newBuilder().withComment("Sales Dept.").withName("John Smith").withEmail("john.smith@example.com").build();
        UserId userId2 = UserId.newBuilder().withComment("Sales Dept.").withName("John Smith").withEmail(upperEmail).build();
        Assertions.assertEquals((Object)userId1, (Object)userId2);
    }

    @Test
    void testNotEqualWithDifferentNames() {
        String name1 = "John Smith";
        String name2 = "Don Duck";
        String comment = "Sales Dept.";
        String email = "john.smith@example.com";
        UserId userId1 = UserId.newBuilder().withComment("Sales Dept.").withName("John Smith").withEmail("john.smith@example.com").build();
        UserId userId2 = UserId.newBuilder().withComment("Sales Dept.").withName("Don Duck").withEmail("john.smith@example.com").build();
        Assertions.assertNotEquals((Object)userId1, (Object)userId2);
    }

    @Test
    void testNotEqualWithDifferentComments() {
        String name = "John Smith";
        String comment1 = "Sales Dept.";
        String comment2 = "Legal Dept.";
        String email = "john.smith@example.com";
        UserId userId1 = UserId.newBuilder().withComment("Sales Dept.").withName("John Smith").withEmail("john.smith@example.com").build();
        UserId userId2 = UserId.newBuilder().withComment("Legal Dept.").withName("John Smith").withEmail("john.smith@example.com").build();
        Assertions.assertNotEquals((Object)userId1, (Object)userId2);
    }
}

