/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.ecc.EllipticCurve;
import org.pgpainless.key.generation.type.xdh.XDHSpec;
import org.pgpainless.util.TestAllImplementations;

public class CertificationKeyMustBeAbleToCertifyTest {
    @TestTemplate
    @ExtendWith(value={TestAllImplementations.class})
    public void testCertificationIncapableKeyTypesThrow() {
        KeyType[] typesIncapableOfCreatingVerifications;
        for (KeyType type : typesIncapableOfCreatingVerifications = new KeyType[]{KeyType.ECDH((EllipticCurve)EllipticCurve._P256), KeyType.ECDH((EllipticCurve)EllipticCurve._P384), KeyType.ECDH((EllipticCurve)EllipticCurve._P521), KeyType.XDH((XDHSpec)XDHSpec._X25519)}) {
            Assertions.assertThrows(IllegalArgumentException.class, () -> ((KeyRingBuilder)PGPainless.buildKeyRing().setPrimaryKey(KeySpec.getBuilder((KeyType)type, (KeyFlag)KeyFlag.CERTIFY_OTHER, (KeyFlag[])new KeyFlag[]{KeyFlag.SIGN_DATA}))).addUserId("should@throw.ex").build());
        }
    }
}

