/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.example;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.key.info.KeyRingInfo;

public class ConvertKeys {
    @Test
    public void secretKeyToCertificate() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        String userId = "alice@wonderland.lit";
        PGPSecretKeyRing secretKey = PGPainless.generateKeyRing().modernKeyRing(userId);
        PGPPublicKeyRing certificate = PGPainless.extractCertificate((PGPSecretKeyRing)secretKey);
        KeyRingInfo secretKeyInfo = PGPainless.inspectKeyRing((PGPKeyRing)secretKey);
        Assertions.assertTrue((boolean)secretKeyInfo.isSecretKey());
        KeyRingInfo certificateInfo = PGPainless.inspectKeyRing((PGPKeyRing)certificate);
        Assertions.assertFalse((boolean)certificateInfo.isSecretKey());
    }
}

