/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature.builder;

import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.signature.builder.AbstractSignatureBuilder;
import org.pgpainless.signature.subpackets.SelfSignatureSubpackets;

public class PrimaryKeyBindingSignatureBuilder
extends AbstractSignatureBuilder<PrimaryKeyBindingSignatureBuilder> {
    public PrimaryKeyBindingSignatureBuilder(PGPSecretKey subkey, SecretKeyRingProtector subkeyProtector) throws PGPException {
        super(SignatureType.PRIMARYKEY_BINDING, subkey, subkeyProtector);
    }

    public SelfSignatureSubpackets getHashedSubpackets() {
        return this.hashedSubpackets;
    }

    public SelfSignatureSubpackets getUnhashedSubpackets() {
        return this.unhashedSubpackets;
    }

    public void applyCallback(@Nullable SelfSignatureSubpackets.Callback callback) {
        if (callback != null) {
            callback.modifyHashedSubpackets(this.getHashedSubpackets());
            callback.modifyUnhashedSubpackets(this.getUnhashedSubpackets());
        }
    }

    @Override
    protected boolean isValidSignatureType(SignatureType type) {
        return type == SignatureType.PRIMARYKEY_BINDING;
    }

    public PGPSignature build(PGPPublicKey primaryKey) throws PGPException {
        return this.buildAndInitSignatureGenerator().generateCertification(primaryKey, this.publicSigningKey);
    }
}

