/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.bcpg.BCPGKey;
import org.bouncycastle.bcpg.DSAPublicBCPGKey;
import org.bouncycastle.bcpg.DSASecretBCPGKey;
import org.bouncycastle.bcpg.EdDSAPublicBCPGKey;
import org.bouncycastle.bcpg.EdSecretBCPGKey;
import org.bouncycastle.bcpg.ElGamalPublicBCPGKey;
import org.bouncycastle.bcpg.ElGamalSecretBCPGKey;
import org.bouncycastle.bcpg.RSAPublicBCPGKey;
import org.bouncycastle.bcpg.RSASecretBCPGKey;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.Streams;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.exception.KeyIntegrityException;
import org.pgpainless.implementation.ImplementationFactory;

public class PublicKeyParameterValidationUtil {
    public static void verifyPublicKeyParameterIntegrity(PGPPrivateKey privateKey, PGPPublicKey publicKey) throws KeyIntegrityException {
        PublicKeyAlgorithm publicKeyAlgorithm = PublicKeyAlgorithm.requireFromId(publicKey.getAlgorithm());
        boolean valid = true;
        BCPGKey key = privateKey.getPrivateKeyDataPacket();
        if (key instanceof RSASecretBCPGKey) {
            valid = PublicKeyParameterValidationUtil.verifyRSAKeyIntegrity((RSASecretBCPGKey)key, (RSAPublicBCPGKey)publicKey.getPublicKeyPacket().getKey()) && valid;
        } else if (key instanceof EdSecretBCPGKey) {
            valid = PublicKeyParameterValidationUtil.verifyEdDsaKeyIntegrity((EdSecretBCPGKey)key, (EdDSAPublicBCPGKey)publicKey.getPublicKeyPacket().getKey()) && valid;
        } else if (key instanceof DSASecretBCPGKey) {
            valid = PublicKeyParameterValidationUtil.verifyDsaKeyIntegrity((DSASecretBCPGKey)key, (DSAPublicBCPGKey)publicKey.getPublicKeyPacket().getKey()) && valid;
        } else if (key instanceof ElGamalSecretBCPGKey) {
            boolean bl = valid = PublicKeyParameterValidationUtil.verifyElGamalKeyIntegrity((ElGamalSecretBCPGKey)key, (ElGamalPublicBCPGKey)publicKey.getPublicKeyPacket().getKey()) && valid;
        }
        if (!valid) {
            throw new KeyIntegrityException();
        }
        if (publicKeyAlgorithm.isSigningCapable()) {
            valid = PublicKeyParameterValidationUtil.verifyCanSign(privateKey, publicKey);
        }
        if (publicKeyAlgorithm.isEncryptionCapable()) {
            boolean bl = valid = PublicKeyParameterValidationUtil.verifyCanDecrypt(privateKey, publicKey) && valid;
        }
        if (!valid) {
            throw new KeyIntegrityException();
        }
    }

    private static boolean verifyCanSign(PGPPrivateKey privateKey, PGPPublicKey publicKey) {
        SecureRandom random = new SecureRandom();
        PublicKeyAlgorithm publicKeyAlgorithm = PublicKeyAlgorithm.requireFromId(publicKey.getAlgorithm());
        PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator(ImplementationFactory.getInstance().getPGPContentSignerBuilder(publicKeyAlgorithm, HashAlgorithm.SHA256));
        try {
            signatureGenerator.init(SignatureType.TIMESTAMP.getCode(), privateKey);
            byte[] data = new byte[512];
            random.nextBytes(data);
            signatureGenerator.update(data);
            PGPSignature sig = signatureGenerator.generate();
            sig.init(ImplementationFactory.getInstance().getPGPContentVerifierBuilderProvider(), publicKey);
            sig.update(data);
            return sig.verify();
        }
        catch (PGPException e) {
            return false;
        }
    }

    private static boolean verifyCanDecrypt(PGPPrivateKey privateKey, PGPPublicKey publicKey) {
        SecureRandom random = new SecureRandom();
        PGPEncryptedDataGenerator encryptedDataGenerator = new PGPEncryptedDataGenerator(ImplementationFactory.getInstance().getPGPDataEncryptorBuilder(SymmetricKeyAlgorithm.AES_256));
        encryptedDataGenerator.addMethod((PGPKeyEncryptionMethodGenerator)ImplementationFactory.getInstance().getPublicKeyKeyEncryptionMethodGenerator(publicKey));
        byte[] data = new byte[1024];
        random.nextBytes(data);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            OutputStream outputStream = encryptedDataGenerator.open((OutputStream)out, new byte[1024]);
            outputStream.write(data);
            encryptedDataGenerator.close();
            PGPEncryptedDataList encryptedDataList = new PGPEncryptedDataList(out.toByteArray());
            PublicKeyDataDecryptorFactory decryptorFactory = ImplementationFactory.getInstance().getPublicKeyDataDecryptorFactory(privateKey);
            PGPPublicKeyEncryptedData encryptedData = (PGPPublicKeyEncryptedData)encryptedDataList.getEncryptedDataObjects().next();
            InputStream decrypted = encryptedData.getDataStream(decryptorFactory);
            out = new ByteArrayOutputStream();
            Streams.pipeAll((InputStream)decrypted, (OutputStream)out);
            decrypted.close();
        }
        catch (IOException | PGPException e) {
            return false;
        }
        return Arrays.constantTimeAreEqual((byte[])data, (byte[])out.toByteArray());
    }

    private static boolean verifyEdDsaKeyIntegrity(EdSecretBCPGKey privateKey, EdDSAPublicBCPGKey publicKey) throws KeyIntegrityException {
        return true;
    }

    private static boolean verifyDsaKeyIntegrity(DSASecretBCPGKey privateKey, DSAPublicBCPGKey publicKey) throws KeyIntegrityException {
        boolean gInBounds;
        boolean qLarge;
        int certainty = 40;
        BigInteger pG = publicKey.getG();
        BigInteger pP = publicKey.getP();
        BigInteger pQ = publicKey.getQ();
        BigInteger pY = publicKey.getY();
        BigInteger sX = privateKey.getX();
        boolean pPrime = pP.isProbablePrime(40);
        if (!pPrime) {
            return false;
        }
        boolean qPrime = pQ.isProbablePrime(40);
        if (!qPrime) {
            return false;
        }
        boolean bl = qLarge = pQ.getLowestSetBit() > 160;
        if (!qLarge) {
            return false;
        }
        boolean qDividesPminus1 = pP.subtract(BigInteger.ONE).mod(pQ).equals(BigInteger.ZERO);
        if (!qDividesPminus1) {
            return false;
        }
        boolean bl2 = gInBounds = BigInteger.ONE.max(pG).equals(pG) && pG.max(pP).equals(pP);
        if (!gInBounds) {
            return false;
        }
        boolean gPowXModPEquals1 = pG.modPow(pQ, pP).equals(BigInteger.ONE);
        if (!gPowXModPEquals1) {
            return false;
        }
        boolean yEqualsGPowXModP = pY.equals(pG.modPow(sX, pP));
        return yEqualsGPowXModP;
    }

    private static boolean verifyRSAKeyIntegrity(RSASecretBCPGKey secretKey, RSAPublicBCPGKey publicKey) throws KeyIntegrityException {
        return publicKey.getModulus().equals(secretKey.getPrimeP().multiply(secretKey.getPrimeQ()));
    }

    private static boolean verifyElGamalKeyIntegrity(ElGamalSecretBCPGKey secretKey, ElGamalPublicBCPGKey publicKey) {
        BigInteger p = publicKey.getP();
        BigInteger g = publicKey.getG();
        BigInteger y = publicKey.getY();
        BigInteger one = BigInteger.ONE;
        if (g.min(one).equals(g) || g.max(p).equals(g)) {
            return false;
        }
        if (p.bitLength() < 1023) {
            return false;
        }
        if (!g.modPow(p.subtract(one), p).equals(one)) {
            return false;
        }
        BigInteger res = g;
        BigInteger i = BigInteger.valueOf(1L);
        BigInteger threshold = BigInteger.valueOf(2L).shiftLeft(17);
        while (i.compareTo(threshold) < 0) {
            if ((res = res.multiply(g).mod(p)).equals(one)) {
                return false;
            }
            i = i.add(one);
        }
        SecureRandom random = new SecureRandom();
        BigInteger x = secretKey.getX();
        BigInteger r = new BigInteger(p.bitLength(), random);
        BigInteger rqx = p.subtract(one).multiply(r).add(x);
        return y.equals(g.modPow(rqx, p));
    }
}

