/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.protection;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.Random;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.protection.CachingSecretKeyRingProtector;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnlockSecretKey;
import org.pgpainless.key.protection.passphrase_provider.SecretKeyPassphraseProvider;
import org.pgpainless.util.Passphrase;

public class CachingSecretKeyRingProtectorTest {
    private final SecretKeyPassphraseProvider dummyCallback = new SecretKeyPassphraseProvider(){

        public Passphrase getPassphraseFor(Long keyId) {
            long doubled = keyId * 2L;
            return Passphrase.fromPassword((String)Long.toString(doubled));
        }

        public boolean hasPassphrase(Long keyId) {
            return true;
        }
    };
    private CachingSecretKeyRingProtector protector;

    @BeforeEach
    public void resetProtectors() {
        this.protector = new CachingSecretKeyRingProtector();
    }

    @Test
    public void noCallbackReturnsNullForUnknownKeyId() throws PGPException {
        Assertions.assertNull((Object)this.protector.getDecryptor(Long.valueOf(123L)));
        Assertions.assertNull((Object)this.protector.getEncryptor(Long.valueOf(123L)));
    }

    @Test
    public void testAddPassphrase() throws PGPException {
        Passphrase passphrase = Passphrase.fromPassword((String)"HelloWorld");
        this.protector.addPassphrase(Long.valueOf(123L), passphrase);
        Assertions.assertEquals((Object)passphrase, (Object)this.protector.getPassphraseFor(Long.valueOf(123L)));
        Assertions.assertNotNull((Object)this.protector.getEncryptor(Long.valueOf(123L)));
        Assertions.assertNotNull((Object)this.protector.getDecryptor(Long.valueOf(123L)));
        Assertions.assertNull((Object)this.protector.getPassphraseFor(Long.valueOf(999L)));
    }

    @Test
    public void testForgetPassphrase() {
        Passphrase passphrase = Passphrase.fromPassword((String)"amnesiac");
        this.protector.addPassphrase(Long.valueOf(123L), passphrase);
        Assertions.assertEquals((Object)passphrase, (Object)this.protector.getPassphraseFor(Long.valueOf(123L)));
        this.protector.forgetPassphrase(Long.valueOf(123L));
        Assertions.assertNull((Object)this.protector.getPassphraseFor(Long.valueOf(123L)));
    }

    @Test
    public void testAddPassphraseForKeyRing() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing keys = PGPainless.generateKeyRing().modernKeyRing("test@test.test", "Passphrase123");
        Passphrase passphrase = Passphrase.fromPassword((String)"Passphrase123");
        this.protector.addPassphrase((PGPKeyRing)keys, passphrase);
        Iterator it = keys.getSecretKeys();
        while (it.hasNext()) {
            PGPSecretKey key = (PGPSecretKey)it.next();
            Assertions.assertEquals((Object)passphrase, (Object)this.protector.getPassphraseFor(key));
            Assertions.assertNotNull((Object)this.protector.getEncryptor(Long.valueOf(key.getKeyID())));
            Assertions.assertNotNull((Object)this.protector.getDecryptor(Long.valueOf(key.getKeyID())));
        }
        long nonMatching = CachingSecretKeyRingProtectorTest.findNonMatchingKeyId((PGPKeyRing)keys);
        Assertions.assertNull((Object)this.protector.getPassphraseFor(Long.valueOf(nonMatching)));
        this.protector.forgetPassphrase((PGPKeyRing)keys);
        it = keys.getSecretKeys();
        while (it.hasNext()) {
            PGPSecretKey key = (PGPSecretKey)it.next();
            Assertions.assertNull((Object)this.protector.getPassphraseFor(key));
            Assertions.assertNull((Object)this.protector.getEncryptor(Long.valueOf(key.getKeyID())));
            Assertions.assertNull((Object)this.protector.getDecryptor(Long.valueOf(key.getKeyID())));
        }
    }

    private static long findNonMatchingKeyId(PGPKeyRing keyRing) {
        Random random = new Random();
        long nonMatchingKeyId = 123L;
        block0: while (true) {
            Iterator pubKeys = keyRing.getPublicKeys();
            while (pubKeys.hasNext()) {
                if (((PGPPublicKey)pubKeys.next()).getKeyID() != nonMatchingKeyId) continue;
                nonMatchingKeyId = random.nextLong();
                continue block0;
            }
            break;
        }
        return nonMatchingKeyId;
    }

    @Test
    public void testProtectorWithCallback() {
        CachingSecretKeyRingProtector withCallback = new CachingSecretKeyRingProtector(this.dummyCallback);
        for (int i = -5; i <= 5; ++i) {
            long x = i * 5;
            long doubled = x * 2L;
            Passphrase passphrase = withCallback.getPassphraseFor(Long.valueOf(x));
            Assertions.assertNotNull((Object)passphrase);
            Assertions.assertEquals((long)doubled, (long)Long.valueOf(new String(passphrase.getChars())));
        }
    }

    @Test
    public void testAddPassphrase_collision() throws PGPException, IOException {
        PGPSecretKeyRing secretKeys = TestKeys.getCryptieSecretKeyRing();
        CachingSecretKeyRingProtector protector = new CachingSecretKeyRingProtector();
        protector.addPassphrase((PGPKeyRing)secretKeys, TestKeys.CRYPTIE_PASSPHRASE);
        Assertions.assertThrows(IllegalArgumentException.class, () -> protector.addPassphrase(secretKeys.getPublicKey(), Passphrase.emptyPassphrase()));
        Assertions.assertThrows(IllegalArgumentException.class, () -> protector.addPassphrase((PGPKeyRing)secretKeys, Passphrase.fromPassword((String)"anotherPass")));
    }

    @Test
    public void testReplacePassphrase() throws PGPException, IOException {
        PGPSecretKeyRing secretKeys = TestKeys.getCryptieSecretKeyRing();
        CachingSecretKeyRingProtector protector = new CachingSecretKeyRingProtector();
        protector.addPassphrase((PGPKeyRing)secretKeys, Passphrase.fromPassword((String)"wrong"));
        protector.replacePassphrase((PGPKeyRing)secretKeys, TestKeys.CRYPTIE_PASSPHRASE);
        for (PGPSecretKey key : secretKeys) {
            UnlockSecretKey.unlockSecretKey((PGPSecretKey)key, (SecretKeyRingProtector)protector);
        }
    }
}

