/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyDataDecryptorFactory;
import org.pgpainless.decryption_verification.CustomPublicKeyDataDecryptorFactory;
import org.pgpainless.key.SubkeyIdentifier;

public class HardwareSecurity {

    public static class HardwareSecurityException
    extends Exception {
    }

    public static class HardwareDataDecryptorFactory
    implements CustomPublicKeyDataDecryptorFactory {
        private final DecryptionCallback callback;
        private final PublicKeyDataDecryptorFactory factory = new BcPublicKeyDataDecryptorFactory(null);
        private final SubkeyIdentifier subkey;

        public HardwareDataDecryptorFactory(SubkeyIdentifier subkeyIdentifier, DecryptionCallback callback) {
            this.callback = callback;
            this.subkey = subkeyIdentifier;
        }

        public byte[] recoverSessionData(int keyAlgorithm, byte[][] secKeyData) throws PGPException {
            try {
                return this.callback.decryptSessionKey(this.subkey.getSubkeyId(), keyAlgorithm, secKeyData[0]);
            }
            catch (HardwareSecurityException e) {
                throw new PGPException("Hardware-backed decryption failed.", (Exception)e);
            }
        }

        public PGPDataDecryptor createDataDecryptor(boolean withIntegrityPacket, int encAlgorithm, byte[] key) throws PGPException {
            return this.factory.createDataDecryptor(withIntegrityPacket, encAlgorithm, key);
        }

        public PGPDataDecryptor createDataDecryptor(int aeadAlgorithm, byte[] iv, int chunkSize, int encAlgorithm, byte[] key) throws PGPException {
            return this.factory.createDataDecryptor(aeadAlgorithm, iv, chunkSize, encAlgorithm, key);
        }

        @Override
        public SubkeyIdentifier getSubkeyIdentifier() {
            return this.subkey;
        }
    }

    public static interface DecryptionCallback {
        public byte[] decryptSessionKey(long var1, int var3, byte[] var4) throws HardwareSecurityException;
    }
}

