/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.io.OutputStream;
import java.security.MessageDigest;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.DSA;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.signers.DSADigestSigner;
import org.bouncycastle.crypto.signers.DSASigner;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.Ed25519Signer;
import org.bouncycastle.crypto.signers.Ed448Signer;
import org.bouncycastle.crypto.signers.RSADigestSigner;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.operator.PGPContentSigner;
import org.bouncycastle.openpgp.operator.bc.BcPGPKeyConverter;
import org.bouncycastle.util.Arrays;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.encryption_signing.PGPHashContextContentSignerBuilder;

class BcPGPHashContextContentSignerBuilder
extends PGPHashContextContentSignerBuilder {
    private final BcPGPKeyConverter keyConverter = new BcPGPKeyConverter();
    private final MessageDigest messageDigest;
    private final HashAlgorithm hashAlgorithm;

    BcPGPHashContextContentSignerBuilder(MessageDigest messageDigest) {
        this.messageDigest = messageDigest;
        this.hashAlgorithm = HashAlgorithm.fromName(messageDigest.getAlgorithm());
        if (this.hashAlgorithm == null) {
            throw new IllegalArgumentException("Cannot recognize OpenPGP Hash Algorithm: " + messageDigest.getAlgorithm());
        }
    }

    public PGPContentSigner build(final int signatureType, final PGPPrivateKey privateKey) throws PGPException {
        final PublicKeyAlgorithm keyAlgorithm = PublicKeyAlgorithm.requireFromId(privateKey.getPublicKeyPacket().getAlgorithm());
        AsymmetricKeyParameter privKeyParam = this.keyConverter.getPrivateKey(privateKey);
        final Signer signer = BcPGPHashContextContentSignerBuilder.createSigner(keyAlgorithm, this.messageDigest, (CipherParameters)privKeyParam);
        signer.init(true, (CipherParameters)privKeyParam);
        return new PGPContentSigner(){

            public int getType() {
                return signatureType;
            }

            public int getHashAlgorithm() {
                return BcPGPHashContextContentSignerBuilder.this.hashAlgorithm.getAlgorithmId();
            }

            public int getKeyAlgorithm() {
                return keyAlgorithm.getAlgorithmId();
            }

            public long getKeyID() {
                return privateKey.getKeyID();
            }

            public OutputStream getOutputStream() {
                return new PGPHashContextContentSignerBuilder.SignerOutputStream(signer);
            }

            public byte[] getSignature() {
                try {
                    return signer.generateSignature();
                }
                catch (CryptoException e) {
                    throw new IllegalStateException("unable to create signature");
                }
            }

            public byte[] getDigest() {
                return BcPGPHashContextContentSignerBuilder.this.messageDigest.digest();
            }
        };
    }

    static Signer createSigner(PublicKeyAlgorithm keyAlgorithm, MessageDigest messageDigest, CipherParameters keyParam) throws PGPException {
        PGPHashContextContentSignerBuilder.ExistingMessageDigest staticDigest = new PGPHashContextContentSignerBuilder.ExistingMessageDigest(messageDigest);
        switch (keyAlgorithm.getAlgorithmId()) {
            case 1: 
            case 3: {
                return new RSADigestSigner((Digest)staticDigest);
            }
            case 17: {
                return new DSADigestSigner((DSA)new DSASigner(), (Digest)staticDigest);
            }
            case 19: {
                return new DSADigestSigner((DSA)new ECDSASigner(), (Digest)staticDigest);
            }
            case 22: {
                if (keyParam instanceof Ed25519PrivateKeyParameters || keyParam instanceof Ed25519PublicKeyParameters) {
                    return new EdDsaSigner((Signer)new Ed25519Signer(), staticDigest);
                }
                return new EdDsaSigner((Signer)new Ed448Signer(new byte[0]), staticDigest);
            }
        }
        throw new PGPException("cannot recognise keyAlgorithm: " + (Object)((Object)keyAlgorithm));
    }

    private static class EdDsaSigner
    implements Signer {
        private final Signer signer;
        private final Digest digest;
        private final byte[] digBuf;

        EdDsaSigner(Signer signer, Digest digest) {
            this.signer = signer;
            this.digest = digest;
            this.digBuf = new byte[digest.getDigestSize()];
        }

        public void init(boolean forSigning, CipherParameters param) {
            this.signer.init(forSigning, param);
            this.digest.reset();
        }

        public void update(byte b) {
            this.digest.update(b);
        }

        public void update(byte[] in, int off, int len) {
            this.digest.update(in, off, len);
        }

        public byte[] generateSignature() throws CryptoException, DataLengthException {
            this.digest.doFinal(this.digBuf, 0);
            this.signer.update(this.digBuf, 0, this.digBuf.length);
            return this.signer.generateSignature();
        }

        public boolean verifySignature(byte[] signature) {
            this.digest.doFinal(this.digBuf, 0);
            this.signer.update(this.digBuf, 0, this.digBuf.length);
            return this.signer.verifySignature(signature);
        }

        public void reset() {
            Arrays.clear((byte[])this.digBuf);
            this.signer.reset();
            this.digest.reset();
        }
    }
}

