/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.util;

import javax.annotation.Nonnull;

public final class UserId
implements CharSequence {
    private final String name;
    private final String comment;
    private final String email;
    private long hash = Long.MAX_VALUE;

    private UserId(String name, String comment, String email) {
        this.name = name;
        this.comment = comment;
        this.email = email;
    }

    public static UserId onlyEmail(String email) {
        UserId.checkNotNull("email", email);
        return new UserId(null, null, email);
    }

    public static UserId nameAndEmail(String name, String email) {
        UserId.checkNotNull("name", name);
        UserId.checkNotNull("email", email);
        return new UserId(name, null, email);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this.name, this.comment, this.email);
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public String getEmail() {
        return this.email;
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int i) {
        return this.toString().charAt(i);
    }

    @Override
    @Nonnull
    public CharSequence subSequence(int i, int i1) {
        return this.toString().subSequence(i, i1);
    }

    @Override
    @Nonnull
    public String toString() {
        return this.asString(false);
    }

    public String asString(boolean ignoreEmptyValues) {
        StringBuilder sb = new StringBuilder();
        if (!(this.name == null || ignoreEmptyValues && this.name.isEmpty())) {
            sb.append(this.name);
        }
        if (!(this.comment == null || ignoreEmptyValues && this.comment.isEmpty())) {
            sb.append(" (").append(this.comment).append(')');
        }
        if (!(this.email == null || ignoreEmptyValues && this.email.isEmpty())) {
            boolean moreThanJustEmail;
            boolean bl = moreThanJustEmail = sb.length() > 0;
            if (moreThanJustEmail) {
                sb.append(" <");
            }
            sb.append(this.email);
            if (moreThanJustEmail) {
                sb.append('>');
            }
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserId)) {
            return false;
        }
        UserId other = (UserId)o;
        return UserId.isEqualComponent(this.name, other.name, false) && UserId.isEqualComponent(this.comment, other.comment, false) && UserId.isEqualComponent(this.email, other.email, true);
    }

    public int hashCode() {
        if (this.hash != Long.MAX_VALUE) {
            return (int)this.hash;
        }
        int hashCode = 7;
        hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
        hashCode = 31 * hashCode + (this.comment == null ? 0 : this.comment.hashCode());
        hashCode = 31 * hashCode + (this.email == null ? 0 : this.email.toLowerCase().hashCode());
        this.hash = hashCode;
        return hashCode;
    }

    private static boolean isEqualComponent(String value, String otherValue, boolean ignoreCase) {
        boolean otherValueIsNull;
        boolean valueIsNull = value == null;
        boolean bl = otherValueIsNull = otherValue == null;
        return valueIsNull && otherValueIsNull || !valueIsNull && !otherValueIsNull && (ignoreCase ? value.equalsIgnoreCase(otherValue) : value.equals(otherValue));
    }

    private static void checkNotNull(String paramName, String value) {
        if (value == null) {
            throw new IllegalArgumentException(paramName + " must be not null");
        }
    }

    public static final class Builder {
        private String name;
        private String comment;
        private String email;

        private Builder() {
        }

        private Builder(String name, String comment, String email) {
            this.name = name;
            this.comment = comment;
            this.email = email;
        }

        public Builder withName(String name) {
            UserId.checkNotNull("name", name);
            this.name = name;
            return this;
        }

        public Builder withComment(String comment) {
            UserId.checkNotNull("comment", comment);
            this.comment = comment;
            return this;
        }

        public Builder withEmail(String email) {
            UserId.checkNotNull("email", email);
            this.email = email;
            return this;
        }

        public Builder noName() {
            this.name = null;
            return this;
        }

        public Builder noComment() {
            this.comment = null;
            return this;
        }

        public Builder noEmail() {
            this.email = null;
            return this;
        }

        public UserId build() {
            return new UserId(this.name, this.comment, this.email);
        }
    }
}

