/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.bouncycastle.openpgp.PGPCanonicalizedDataGenerator;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LiteralDataCRLFEncodingTest {
    @Test
    public void testCanonicalization() throws IOException {
        PGPCanonicalizedDataGenerator generator = new PGPCanonicalizedDataGenerator();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStream canonicalizer = generator.open((OutputStream)out, 'u', "", new Date(), new byte[512]);
        ByteArrayInputStream in = new ByteArrayInputStream("Foo\nBar\n".getBytes(StandardCharsets.UTF_8));
        Streams.pipeAll((InputStream)in, (OutputStream)canonicalizer);
        canonicalizer.close();
        byte[] bytes = out.toByteArray();
        byte[] canonicalized = new byte[bytes.length - 8];
        System.arraycopy(bytes, 8, canonicalized, 0, canonicalized.length);
        Assertions.assertArrayEquals((byte[])new byte[]{70, 111, 111, 13, 10, 66, 97, 114, 13, 10}, (byte[])canonicalized);
    }
}

