/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.util.CollectionUtils;

public class PGPPublicKeyRingTest {
    @Test
    public void subkeysDoNotHaveUserIDsTest() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().simpleEcKeyRing("primary@user.id");
        PGPPublicKeyRing publicKeys = KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)secretKeys);
        PGPPublicKey primaryKey = publicKeys.getPublicKey();
        for (PGPPublicKey subkey : publicKeys) {
            Iterator userIds = subkey.getUserIDs();
            if (primaryKey == subkey) {
                Assertions.assertEquals((Object)"primary@user.id", userIds.next());
            }
            Assertions.assertFalse((boolean)userIds.hasNext());
        }
    }

    @Test
    public void removeUserIdTest() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        String userId = "alice@wonderland.lit";
        PGPSecretKeyRing secretKeyRing = PGPainless.generateKeyRing().simpleEcKeyRing(userId);
        PGPPublicKeyRing publicKeys = KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)secretKeyRing);
        List userIds = CollectionUtils.iteratorToList((Iterator)publicKeys.getPublicKey().getUserIDs());
        Assertions.assertTrue((boolean)userIds.contains(userId));
        PGPPublicKey publicKey = publicKeys.getPublicKey();
        publicKey = PGPPublicKey.removeCertification((PGPPublicKey)publicKey, (String)userId);
        userIds = CollectionUtils.iteratorToList((Iterator)publicKey.getUserIDs());
        Assertions.assertFalse((boolean)userIds.contains(userId));
    }
}

