/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.algorithm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.algorithm.negotiation.SymmetricKeyAlgorithmNegotiator;
import org.pgpainless.policy.Policy;

public class SymmetricKeyAlgorithmNegotiatorTest {
    private final SymmetricKeyAlgorithmNegotiator byPopularity = SymmetricKeyAlgorithmNegotiator.byPopularity();
    private final Policy.SymmetricKeyAlgorithmPolicy policy = new Policy.SymmetricKeyAlgorithmPolicy(SymmetricKeyAlgorithm.CAMELLIA_256, Arrays.asList(SymmetricKeyAlgorithm.AES_256, SymmetricKeyAlgorithm.AES_192, SymmetricKeyAlgorithm.AES_128, SymmetricKeyAlgorithm.CAMELLIA_256));

    @Test
    public void byPopularityReturnsOverrideIfNotNull() {
        Assertions.assertEquals((Object)SymmetricKeyAlgorithm.AES_192, (Object)this.byPopularity.negotiate(this.policy, SymmetricKeyAlgorithm.AES_192, Collections.emptyList()));
    }

    @Test
    public void byPopularityThrowsIAEForUnencryptedOverride() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.byPopularity.negotiate(this.policy, SymmetricKeyAlgorithm.NULL, Collections.emptyList()));
    }

    @Test
    public void byPopularityChoosesMostPopularAlgorithm() {
        ArrayList<LinkedHashSet> preferences = new ArrayList<LinkedHashSet>();
        preferences.add(new LinkedHashSet<SymmetricKeyAlgorithm>(){
            {
                this.add(SymmetricKeyAlgorithm.AES_128);
                this.add(SymmetricKeyAlgorithm.AES_192);
                this.add(SymmetricKeyAlgorithm.AES_256);
            }
        });
        preferences.add(new LinkedHashSet<SymmetricKeyAlgorithm>(){
            {
                this.add(SymmetricKeyAlgorithm.AES_128);
                this.add(SymmetricKeyAlgorithm.AES_192);
            }
        });
        preferences.add(new LinkedHashSet<SymmetricKeyAlgorithm>(){
            {
                this.add(SymmetricKeyAlgorithm.AES_192);
                this.add(SymmetricKeyAlgorithm.CAMELLIA_256);
            }
        });
        Assertions.assertEquals((Object)SymmetricKeyAlgorithm.AES_192, (Object)this.byPopularity.negotiate(this.policy, null, preferences));
    }

    @Test
    public void byPopularityIgnoresRejectedAlgorithms() {
        ArrayList<LinkedHashSet> preferences = new ArrayList<LinkedHashSet>();
        preferences.add(new LinkedHashSet<SymmetricKeyAlgorithm>(){
            {
                this.add(SymmetricKeyAlgorithm.CAMELLIA_128);
                this.add(SymmetricKeyAlgorithm.CAMELLIA_192);
                this.add(SymmetricKeyAlgorithm.AES_256);
            }
        });
        preferences.add(new LinkedHashSet<SymmetricKeyAlgorithm>(){
            {
                this.add(SymmetricKeyAlgorithm.CAMELLIA_128);
                this.add(SymmetricKeyAlgorithm.CAMELLIA_192);
            }
        });
        preferences.add(new LinkedHashSet<SymmetricKeyAlgorithm>(){
            {
                this.add(SymmetricKeyAlgorithm.CAMELLIA_192);
                this.add(SymmetricKeyAlgorithm.AES_256);
            }
        });
        Assertions.assertEquals((Object)SymmetricKeyAlgorithm.AES_256, (Object)this.byPopularity.negotiate(this.policy, null, preferences));
    }

    @Test
    public void byPopularityChoosesFallbackWhenNoAlgIsAcceptable() {
        ArrayList<LinkedHashSet> preferences = new ArrayList<LinkedHashSet>();
        preferences.add(new LinkedHashSet<SymmetricKeyAlgorithm>(){
            {
                this.add(SymmetricKeyAlgorithm.CAMELLIA_128);
                this.add(SymmetricKeyAlgorithm.CAMELLIA_192);
            }
        });
        preferences.add(new LinkedHashSet<SymmetricKeyAlgorithm>(){
            {
                this.add(SymmetricKeyAlgorithm.CAMELLIA_128);
                this.add(SymmetricKeyAlgorithm.CAMELLIA_192);
            }
        });
        preferences.add(new LinkedHashSet<SymmetricKeyAlgorithm>(){
            {
                this.add(SymmetricKeyAlgorithm.CAMELLIA_192);
                this.add(SymmetricKeyAlgorithm.BLOWFISH);
            }
        });
        Assertions.assertEquals((Object)SymmetricKeyAlgorithm.CAMELLIA_256, (Object)this.byPopularity.negotiate(this.policy, null, preferences));
    }

    @Test
    public void byPopularitySelectsBestOnDraw() {
        ArrayList<LinkedHashSet> preferences = new ArrayList<LinkedHashSet>();
        preferences.add(new LinkedHashSet<SymmetricKeyAlgorithm>(){
            {
                this.add(SymmetricKeyAlgorithm.AES_128);
                this.add(SymmetricKeyAlgorithm.AES_192);
                this.add(SymmetricKeyAlgorithm.AES_256);
            }
        });
        preferences.add(new LinkedHashSet<SymmetricKeyAlgorithm>(){
            {
                this.add(SymmetricKeyAlgorithm.AES_128);
                this.add(SymmetricKeyAlgorithm.AES_256);
            }
        });
        Assertions.assertEquals((Object)SymmetricKeyAlgorithm.AES_256, (Object)this.byPopularity.negotiate(this.policy, null, preferences));
    }
}

