/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key;

import java.io.IOException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.TestKeys;
import org.pgpainless.util.TestAllImplementations;

public class ImportExportKeyTest {
    @TestTemplate
    @ExtendWith(value={TestAllImplementations.class})
    public void testExportImportPublicKeyRing() throws IOException {
        PGPPublicKeyRing publicKeys = TestKeys.getJulietPublicKeyRing();
        KeyFingerPrintCalculator calc = ImplementationFactory.getInstance().getKeyFingerprintCalculator();
        byte[] bytes = publicKeys.getEncoded();
        PGPPublicKeyRing parsed = new PGPPublicKeyRing(bytes, calc);
        Assertions.assertArrayEquals((byte[])publicKeys.getEncoded(), (byte[])parsed.getEncoded());
    }

    @TestTemplate
    @ExtendWith(value={TestAllImplementations.class})
    public void testExportImportSecretKeyRing() throws IOException, PGPException {
        PGPSecretKeyRing secretKeys = TestKeys.getRomeoSecretKeyRing();
        KeyFingerPrintCalculator calc = ImplementationFactory.getInstance().getKeyFingerprintCalculator();
        byte[] bytes = secretKeys.getEncoded();
        PGPSecretKeyRing parsed = new PGPSecretKeyRing(bytes, calc);
        Assertions.assertArrayEquals((byte[])secretKeys.getEncoded(), (byte[])parsed.getEncoded());
        Assertions.assertEquals((long)secretKeys.getPublicKey().getKeyID(), (long)parsed.getPublicKey().getKeyID());
    }
}

