/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key;

import java.util.Comparator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.key.util.UserId;

public class UserIdTest {
    @Test
    public void testFormatOnlyName() {
        Assertions.assertEquals((Object)"Juliet Capulet", (Object)UserId.newBuilder().withName("Juliet Capulet").build().toString());
    }

    @Test
    public void testFormatNameAndComment() {
        Assertions.assertEquals((Object)"Juliet Capulet (from the play)", (Object)UserId.newBuilder().withName("Juliet Capulet").withComment("from the play").noEmail().build().toString());
    }

    @Test
    public void testFormatNameCommentAndMail() {
        Assertions.assertEquals((Object)"Juliet Capulet (from the play) <juliet@capulet.lit>", (Object)UserId.newBuilder().withName("Juliet Capulet").withComment("from the play").withEmail("juliet@capulet.lit").build().toString());
    }

    @Test
    public void testFormatNameAndEmail() {
        Assertions.assertEquals((Object)"Juliet Capulet <juliet@capulet.lit>", (Object)UserId.newBuilder().withName("Juliet Capulet").noComment().withEmail("juliet@capulet.lit").build().toString());
    }

    @Test
    public void testNameAndEmail() {
        UserId userId = UserId.nameAndEmail((String)"Maurice Moss", (String)"moss.m@reynholm.co.uk");
        Assertions.assertEquals((Object)"Maurice Moss <moss.m@reynholm.co.uk>", (Object)userId.toString());
    }

    @Test
    void testBuilderWithName() {
        UserId userId = UserId.newBuilder().withName("John Smith").build();
        Assertions.assertEquals((Object)"John Smith", (Object)userId.getName());
        Assertions.assertNull((Object)userId.getComment());
        Assertions.assertNull((Object)userId.getEmail());
    }

    @Test
    void testBuilderWithComment() {
        UserId userId = UserId.newBuilder().withComment("Sales Dept.").build();
        Assertions.assertNull((Object)userId.getName());
        Assertions.assertEquals((Object)"Sales Dept.", (Object)userId.getComment());
        Assertions.assertNull((Object)userId.getEmail());
    }

    @Test
    void testBuilderWithEmail() {
        UserId userId = UserId.newBuilder().withEmail("john.smith@example.com").build();
        Assertions.assertNull((Object)userId.getName());
        Assertions.assertNull((Object)userId.getComment());
        Assertions.assertEquals((Object)"john.smith@example.com", (Object)userId.getEmail());
    }

    @Test
    void testBuilderWithAll() {
        UserId userId = UserId.newBuilder().withEmail("john.smith@example.com").withName("John Smith").withEmail("john.smith@example.com").withComment("Sales Dept.").build();
        Assertions.assertEquals((Object)"John Smith", (Object)userId.getName());
        Assertions.assertEquals((Object)"Sales Dept.", (Object)userId.getComment());
        Assertions.assertEquals((Object)"john.smith@example.com", (Object)userId.getEmail());
    }

    @Test
    void testBuilderNoName() {
        UserId.Builder builder = UserId.newBuilder().withEmail("john.smith@example.com").withName("John Smith").withComment("Sales Dept.").build().toBuilder();
        UserId userId = builder.noName().build();
        Assertions.assertNull((Object)userId.getName());
        Assertions.assertEquals((Object)"Sales Dept.", (Object)userId.getComment());
        Assertions.assertEquals((Object)"john.smith@example.com", (Object)userId.getEmail());
    }

    @Test
    void testBuilderNoComment() {
        UserId.Builder builder = UserId.newBuilder().withEmail("john.smith@example.com").withName("John Smith").withComment("Sales Dept.").build().toBuilder();
        UserId userId = builder.noComment().build();
        Assertions.assertEquals((Object)"John Smith", (Object)userId.getName());
        Assertions.assertNull((Object)userId.getComment());
        Assertions.assertEquals((Object)"john.smith@example.com", (Object)userId.getEmail());
    }

    @Test
    void testBuilderNoEmail() {
        UserId.Builder builder = UserId.newBuilder().withEmail("john.smith@example.com").withName("John Smith").withComment("Sales Dept.").build().toBuilder();
        UserId userId = builder.noEmail().build();
        Assertions.assertEquals((Object)"John Smith", (Object)userId.getName());
        Assertions.assertEquals((Object)"Sales Dept.", (Object)userId.getComment());
        Assertions.assertNull((Object)userId.getEmail());
    }

    @Test
    void testEmailOnlyFormatting() {
        UserId userId = UserId.onlyEmail((String)"john.smith@example.com");
        Assertions.assertEquals((Object)"<john.smith@example.com>", (Object)userId.toString());
    }

    @Test
    void testEmptyNameAndValidEmailFormatting() {
        UserId userId = UserId.nameAndEmail((String)"", (String)"john.smith@example.com");
        Assertions.assertEquals((Object)"<john.smith@example.com>", (Object)userId.toString());
    }

    @Test
    void testEmptyNameAndEmptyCommentAndValidEmailFormatting() {
        UserId userId = UserId.newBuilder().withComment("").withName("").withEmail("john.smith@example.com").build();
        Assertions.assertEquals((Object)"<john.smith@example.com>", (Object)userId.toString());
    }

    @Test
    void testEqualsWithDifferentCaseEmails() {
        String name = "John Smith";
        String comment = "Sales Dept.";
        String email = "john.smith@example.com";
        String upperEmail = "john.smith@example.com".toUpperCase();
        UserId userId1 = UserId.newBuilder().withComment("Sales Dept.").withName("John Smith").withEmail("john.smith@example.com").build();
        UserId userId2 = UserId.newBuilder().withComment("Sales Dept.").withName("John Smith").withEmail(upperEmail).build();
        Assertions.assertEquals((Object)userId1, (Object)userId2);
    }

    @Test
    void testNotEqualWithDifferentNames() {
        String name1 = "John Smith";
        String name2 = "Don Duck";
        String comment = "Sales Dept.";
        String email = "john.smith@example.com";
        UserId userId1 = UserId.newBuilder().withComment("Sales Dept.").withName("John Smith").withEmail("john.smith@example.com").build();
        UserId userId2 = UserId.newBuilder().withComment("Sales Dept.").withName("Don Duck").withEmail("john.smith@example.com").build();
        Assertions.assertNotEquals((Object)userId1, (Object)userId2);
    }

    @Test
    void testNotEqualWithDifferentComments() {
        String name = "John Smith";
        String comment1 = "Sales Dept.";
        String comment2 = "Legal Dept.";
        String email = "john.smith@example.com";
        UserId userId1 = UserId.newBuilder().withComment("Sales Dept.").withName("John Smith").withEmail("john.smith@example.com").build();
        UserId userId2 = UserId.newBuilder().withComment("Legal Dept.").withName("John Smith").withEmail("john.smith@example.com").build();
        Assertions.assertNotEquals((Object)userId1, (Object)userId2);
    }

    @Test
    public void testLength() {
        UserId id = UserId.nameAndEmail((String)"Alice", (String)"alice@pgpainless.org");
        Assertions.assertEquals((int)28, (int)id.length());
    }

    @Test
    public void testSubSequence() {
        UserId id = UserId.onlyEmail((String)"alice@pgpainless.org");
        Assertions.assertEquals((Object)"alice@pgpainless.org", (Object)id.subSequence(1, id.length() - 1));
    }

    @Test
    public void asStringTest() {
        UserId id = UserId.newBuilder().withName("Alice").withComment("Work Email").withEmail("alice@pgpainless.org").build();
        Assertions.assertEquals((Object)id.toString(), (Object)id.asString());
    }

    @Test
    public void charAtTest() {
        UserId id = UserId.onlyEmail((String)"alice@pgpainless.org");
        Assertions.assertEquals((char)'<', (char)id.charAt(0));
        Assertions.assertEquals((char)'>', (char)id.charAt(id.length() - 1));
    }

    @Test
    public void defaultCompareTest() {
        UserId id1 = UserId.onlyEmail((String)"alice@pgpainless.org");
        UserId id2 = UserId.onlyEmail((String)"alice@gnupg.org");
        UserId id3 = UserId.nameAndEmail((String)"Alice", (String)"alice@pgpainless.org");
        UserId id3_ = UserId.nameAndEmail((String)"Alice", (String)"alice@pgpainless.org");
        UserId id4 = UserId.newBuilder().withName("Alice").build();
        UserId id5 = UserId.newBuilder().withName("Alice").withComment("Work Mail").withEmail("alice@pgpainless.org").build();
        Assertions.assertEquals((int)id3.hashCode(), (int)id3_.hashCode());
        Assertions.assertNotEquals((int)id2.hashCode(), (int)id3.hashCode());
        UserId.DefaultComparator c = new UserId.DefaultComparator();
        Assertions.assertEquals((int)0, (int)UserId.compare(null, null, (Comparator)c));
        Assertions.assertEquals((int)0, (int)UserId.compare((UserId)id1, (UserId)id1, (Comparator)c));
        Assertions.assertNotEquals((int)0, (int)UserId.compare((UserId)id1, null, (Comparator)c));
        Assertions.assertNotEquals((int)0, (int)UserId.compare(null, (UserId)id1, (Comparator)c));
        Assertions.assertNotEquals((int)0, (int)UserId.compare((UserId)id1, (UserId)id2, (Comparator)c));
        Assertions.assertNotEquals((int)0, (int)UserId.compare((UserId)id2, (UserId)id1, (Comparator)c));
        Assertions.assertNotEquals((int)0, (int)UserId.compare((UserId)id1, (UserId)id3, (Comparator)c));
        Assertions.assertNotEquals((int)0, (int)UserId.compare((UserId)id1, (UserId)id4, (Comparator)c));
        Assertions.assertNotEquals((int)0, (int)UserId.compare((UserId)id4, (UserId)id1, (Comparator)c));
        Assertions.assertNotEquals((int)0, (int)UserId.compare((UserId)id2, (UserId)id3, (Comparator)c));
        Assertions.assertNotEquals((int)0, (int)UserId.compare((UserId)id1, (UserId)id5, (Comparator)c));
        Assertions.assertNotEquals((int)0, (int)UserId.compare((UserId)id5, (UserId)id1, (Comparator)c));
        Assertions.assertNotEquals((int)0, (int)UserId.compare((UserId)id3, (UserId)id5, (Comparator)c));
        Assertions.assertNotEquals((int)0, (int)UserId.compare((UserId)id5, (UserId)id3, (Comparator)c));
        Assertions.assertEquals((int)0, (int)UserId.compare((UserId)id3, (UserId)id3, (Comparator)c));
        Assertions.assertEquals((int)0, (int)UserId.compare((UserId)id3, (UserId)id3_, (Comparator)c));
    }

    @Test
    public void defaultIgnoreCaseCompareTest() {
        UserId id1 = UserId.nameAndEmail((String)"Alice", (String)"alice@pgpainless.org");
        UserId id2 = UserId.nameAndEmail((String)"alice", (String)"alice@pgpainless.org");
        UserId id3 = UserId.nameAndEmail((String)"Alice", (String)"Alice@Pgpainless.Org");
        UserId id4 = UserId.newBuilder().withName("Alice").withComment("Work Email").withEmail("Alice@Pgpainless.Org").build();
        UserId id5 = UserId.newBuilder().withName("alice").withComment("work email").withEmail("alice@pgpainless.org").build();
        UserId id6 = UserId.nameAndEmail((String)"Bob", (String)"bob@pgpainless.org");
        UserId.DefaultIgnoreCaseComparator c = new UserId.DefaultIgnoreCaseComparator();
        Assertions.assertEquals((int)0, (int)UserId.compare((UserId)id1, (UserId)id2, (Comparator)c));
        Assertions.assertEquals((int)0, (int)UserId.compare((UserId)id1, (UserId)id3, (Comparator)c));
        Assertions.assertEquals((int)0, (int)UserId.compare((UserId)id2, (UserId)id3, (Comparator)c));
        Assertions.assertEquals((int)0, (int)UserId.compare(null, null, (Comparator)c));
        Assertions.assertEquals((int)0, (int)UserId.compare((UserId)id1, (UserId)id1, (Comparator)c));
        Assertions.assertEquals((int)0, (int)UserId.compare((UserId)id4, (UserId)id4, (Comparator)c));
        Assertions.assertEquals((int)0, (int)UserId.compare((UserId)id4, (UserId)id5, (Comparator)c));
        Assertions.assertEquals((int)0, (int)UserId.compare((UserId)id5, (UserId)id4, (Comparator)c));
        Assertions.assertNotEquals((int)0, (int)UserId.compare(null, (UserId)id1, (Comparator)c));
        Assertions.assertNotEquals((int)0, (int)UserId.compare((UserId)id1, null, (Comparator)c));
        Assertions.assertNotEquals((int)0, (int)UserId.compare((UserId)id1, (UserId)id4, (Comparator)c));
        Assertions.assertNotEquals((int)0, (int)UserId.compare((UserId)id4, (UserId)id1, (Comparator)c));
        Assertions.assertNotEquals((int)0, (int)UserId.compare((UserId)id1, (UserId)id6, (Comparator)c));
        Assertions.assertNotEquals((int)0, (int)UserId.compare((UserId)id6, (UserId)id1, (Comparator)c));
    }
}

