/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key;

import java.io.IOException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.key.OpenPgpFingerprint;

public class V3KeyBehaviorTest {
    private static final String V3Cert = "-----BEGIN PGP PUBLIC KEY BLOCK-----\n\nmQCNA2JqgDIAAAEEAOYdcIKFQ5ZWBx0D5DKwMMNFcIhFyqmfDJ0v23ehMxOkXN/o\nHO/43+dq6ZqQn0gNw53Tp9no+EmcCYNrZuN0C4Zu8XHSyY6UB+CqzNkz/CwmV10E\ndRDipcG1O6scJyy2MWpuOG67til+o+wOLgEkkVkSW8Bl2oqtzVVP4swtKLRZAAUR\ntClKb2huIFEuIFNtaXRoIDwxMjM0NS42Nzg5QGNvbXB1c2VydmUuY29tPokAlQMF\nEGJqgDJVT+LMLSi0WQEBgiwEALKQnuzza+oIgp7CAukW6qhUaOV/Cf3P4bWhru+v\n8bED+YUOvgTytnXK1QUxQJ/PLnYV860NBRVR46kCtpZDgl+NeQe4O5lxbZVGHZy1\nP+FUcbvUaA5ZQEfcR5cBJKcWO9RUTf28SMSyJ1ozFm0yPmOa2J5MwHylIbVAlc9c\nag3J\n=GebS\n-----END PGP PUBLIC KEY BLOCK-----\n";
    private static final String V3Key = "-----BEGIN PGP PRIVATE KEY BLOCK-----\n\nlQHYA2JqgDIAAAEEAOYdcIKFQ5ZWBx0D5DKwMMNFcIhFyqmfDJ0v23ehMxOkXN/o\nHO/43+dq6ZqQn0gNw53Tp9no+EmcCYNrZuN0C4Zu8XHSyY6UB+CqzNkz/CwmV10E\ndRDipcG1O6scJyy2MWpuOG67til+o+wOLgEkkVkSW8Bl2oqtzVVP4swtKLRZAAUR\nAAP+JBiyRqt+DYr8GKE85NBX9nlS6DMaxUYgGKgibR5OSVsJjIjNUtG0sNmODjTN\nsPMZqlNln6wS3l7APMWNoStNGc9JG9Puz3eR2W69lPDzhuxuxrHIUBO+3UlEQB/p\nN3NPhnwCjh3OWHSMM6rzsX5ExUv0Z4FypnzvMG1x6GRJDVECAO6PyY8NDHsktMVN\nHAdgC61iIOz+GbLhNGeikuB+DQpSoyckAF0N5reBxRbyjzNZQ7aVvWpxigUp5OdK\nHMK7YcwTAgD275bcqhd+oWHDhyesi6RVswlqGfix48qahf9wOmDkc0nzp8evy/4V\n4Qu5zUJGVzi4aEIbFaAnc5lMD9/ydTNjAf485vh4MDFRd3tPvx9mPrHQgaArCBX8\n9oImPDk0oaKixwSIFzXeg1qZQeLiwv26Fs8gawWsLVZpR4+zZc1nhZlGnrQpSm9o\nbiBRLiBTbWl0aCA8MTIzNDUuNjc4OUBjb21wdXNlcnZlLmNvbT6JAJUDBRBiaoAy\nVU/izC0otFkBAYIsBACykJ7s82vqCIKewgLpFuqoVGjlfwn9z+G1oa7vr/GxA/mF\nDr4E8rZ1ytUFMUCfzy52FfOtDQUVUeOpAraWQ4JfjXkHuDuZcW2VRh2ctT/hVHG7\n1GgOWUBH3EeXASSnFjvUVE39vEjEsidaMxZtMj5jmtieTMB8pSG1QJXPXGoNyQ==\n=p7Lr\n-----END PGP PRIVATE KEY BLOCK-----\n";

    @Test
    public void readV3PublicKey() throws IOException {
        PGPPublicKeyRing cert = PGPainless.readKeyRing().publicKeyRing(V3Cert);
        Assertions.assertEquals((int)3, (int)cert.getPublicKey().getVersion());
        Assertions.assertEquals((Object)"John Q. Smith <12345.6789@compuserve.com>", cert.getPublicKey().getUserIDs().next());
    }

    @Test
    public void readV3SecretKey() throws IOException {
        PGPSecretKeyRing key = PGPainless.readKeyRing().secretKeyRing(V3Key);
        Assertions.assertEquals((int)3, (int)key.getPublicKey().getVersion());
        Assertions.assertEquals((Object)"John Q. Smith <12345.6789@compuserve.com>", key.getPublicKey().getUserIDs().next());
    }

    @Test
    public void extractV3Cert() throws IOException {
        PGPSecretKeyRing key = PGPainless.readKeyRing().secretKeyRing(V3Key);
        PGPPublicKeyRing cert = PGPainless.readKeyRing().publicKeyRing(V3Cert);
        PGPPublicKeyRing extractedCert = PGPainless.extractCertificate((PGPSecretKeyRing)key);
        Assertions.assertArrayEquals((byte[])cert.getEncoded(), (byte[])extractedCert.getEncoded());
    }

    @Test
    public void v3FingerprintNotSupported() throws IOException {
        PGPSecretKeyRing key = PGPainless.readKeyRing().secretKeyRing(V3Key);
        Assertions.assertThrows(IllegalArgumentException.class, () -> OpenPgpFingerprint.of((PGPKeyRing)key));
        PGPPublicKeyRing cert = PGPainless.readKeyRing().publicKeyRing(V3Cert);
        Assertions.assertThrows(IllegalArgumentException.class, () -> OpenPgpFingerprint.of((PGPKeyRing)cert));
    }
}

