/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.JUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.ecc.EllipticCurve;
import org.pgpainless.key.generation.type.eddsa.EdDSACurve;
import org.pgpainless.key.generation.type.xdh.XDHSpec;
import org.pgpainless.util.DateUtil;

public class GenerateKeyWithCustomCreationDateTest {
    @Test
    public void generateKeyWithCustomCreationDateTest() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        Date creationDate = DateUtil.parseUTCDate((String)"2018-06-11 14:12:09 UTC");
        PGPSecretKeyRing secretKeys = ((KeyRingBuilder)((KeyRingBuilder)PGPainless.buildKeyRing().addSubkey(KeySpec.getBuilder((KeyType)KeyType.XDH((XDHSpec)XDHSpec._X25519), (KeyFlag)KeyFlag.ENCRYPT_COMMS, (KeyFlag[])new KeyFlag[]{KeyFlag.ENCRYPT_STORAGE}))).setPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.EDDSA((EdDSACurve)EdDSACurve._Ed25519), (KeyFlag)KeyFlag.CERTIFY_OTHER, (KeyFlag[])new KeyFlag[]{KeyFlag.SIGN_DATA}).setKeyCreationDate(creationDate))).addUserId("Alice").build();
        Iterator iterator = secretKeys.iterator();
        PGPPublicKey primaryKey = ((PGPSecretKey)iterator.next()).getPublicKey();
        PGPPublicKey subkey = ((PGPSecretKey)iterator.next()).getPublicKey();
        JUtils.assertDateEquals(creationDate, primaryKey.getCreationTime());
        JUtils.assertDateNotEquals(creationDate, subkey.getCreationTime());
    }

    @Test
    public void generateSubkeyWithFutureKeyCreationDate() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, 20);
        Date future = calendar.getTime();
        PGPSecretKeyRing secretKeys = ((KeyRingBuilder)((KeyRingBuilder)PGPainless.buildKeyRing().addSubkey(KeySpec.getBuilder((KeyType)KeyType.ECDH((EllipticCurve)EllipticCurve._P384), (KeyFlag)KeyFlag.ENCRYPT_COMMS, (KeyFlag[])new KeyFlag[]{KeyFlag.ENCRYPT_STORAGE}).setKeyCreationDate(future))).setPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.ECDSA((EllipticCurve)EllipticCurve._P384), (KeyFlag)KeyFlag.CERTIFY_OTHER, (KeyFlag[])new KeyFlag[]{KeyFlag.SIGN_DATA}))).addUserId("Captain Future <cpt@futu.re>").build();
        Assertions.assertFalse((boolean)PGPainless.inspectKeyRing((PGPKeyRing)secretKeys).isUsableForEncryption());
    }
}

