/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.modification;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.ecc.EllipticCurve;
import org.pgpainless.key.generation.type.ecc.ecdsa.ECDSA;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.PasswordBasedSecretKeyRingProtector;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnlockSecretKey;
import org.pgpainless.util.Passphrase;
import org.pgpainless.util.TestAllImplementations;

public class AddSubKeyTest {
    @TestTemplate
    @ExtendWith(value={TestAllImplementations.class})
    public void testAddSubKey() throws IOException, PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing secretKeys = TestKeys.getCryptieSecretKeyRing();
        ArrayList<Long> keyIdsBefore = new ArrayList<Long>();
        Iterator it = secretKeys.getPublicKeys();
        while (it.hasNext()) {
            keyIdsBefore.add(((PGPPublicKey)it.next()).getKeyID());
        }
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).addSubKey(KeySpec.getBuilder((KeyType)ECDSA.fromCurve((EllipticCurve)EllipticCurve._P256), (KeyFlag)KeyFlag.SIGN_DATA, (KeyFlag[])new KeyFlag[0]).build(), Passphrase.fromPassword((String)"subKeyPassphrase"), (SecretKeyRingProtector)PasswordBasedSecretKeyRingProtector.forKey((PGPKeyRing)secretKeys, (Passphrase)Passphrase.fromPassword((String)"password123"))).done();
        ArrayList<Long> keyIdsAfter = new ArrayList<Long>();
        Iterator it2 = secretKeys.getPublicKeys();
        while (it2.hasNext()) {
            keyIdsAfter.add(((PGPPublicKey)it2.next()).getKeyID());
        }
        Assertions.assertNotEquals(keyIdsAfter, keyIdsBefore);
        keyIdsAfter.removeAll(keyIdsBefore);
        long subKeyId = (Long)keyIdsAfter.get(0);
        PGPSecretKey subKey = secretKeys.getSecretKey(subKeyId);
        SecretKeyRingProtector protector = SecretKeyRingProtector.unlockEachKeyWith((Passphrase)Passphrase.fromPassword((String)"subKeyPassphrase"), (PGPSecretKeyRing)secretKeys);
        UnlockSecretKey.unlockSecretKey((PGPSecretKey)subKey, (SecretKeyRingProtector)protector);
        KeyRingInfo info = new KeyRingInfo((PGPKeyRing)secretKeys);
        Assertions.assertEquals(Collections.singletonList(KeyFlag.SIGN_DATA), (Object)info.getKeyFlagsOf(subKeyId));
    }
}

