/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.modification;

import java.io.IOException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.key.info.KeyRingInfo;

public class RevokedKeyTest {
    private static final String REVOKED = "-----BEGIN PGP PUBLIC KEY BLOCK-----\n\nxjMEYumXWhYJKwYBBAHaRw8BAQdAsesa7C2dtchG2LDYRPVgNiyXDDltTIW0\n7hbPKuklr+LCeAQgFgoACQUCYume7wIdAAAhCRARRbJWkH7x7hYhBCHmM1W/\nk8Vt/xDX4xFFslaQfvHusjoBAKeMumYgtr1uwbcNobWhojRjik+Uq7jER1Ph\nzrZPPwyaAP9NpV4//AB5BbwUgHMhCErD8L6GZEBOpCWYDgS00eKmCc0kVGVz\ndCBVc2VyIDx0ZXN0LnVzZXJAZmxvd2NyeXB0LnRlc3Q+wqcEExYIADgWIQQh\n5jNVv5PFbf8Q1+MRRbJWkH7x7gUCYumXWgIbAwULCQgHAgYVCgkICwIEFgID\nAQIeAQIXgAAhCRARRbJWkH7x7hYhBCHmM1W/k8Vt/xDX4xFFslaQfvHu0GUB\nAJ/FAi0K0YQ/gv9fO2EwSLH9imrXSxtfkzAyCQS32A/IAQDdqUfbABEoQvo2\nn1ktpVXroW3XPe3HlYFwSQzpVSHADc44BGLpl1oSCisGAQQBl1UBBQEBB0DJ\n8e0hG6v64O4P3qa9n8FxrkNoKS+J+fAW1Vzpf5tBUQMBCAfCjwQYFggAIBYh\nBCHmM1W/k8Vt/xDX4xFFslaQfvHuBQJi6ZdaAhsMACEJEBFFslaQfvHuFiEE\nIeYzVb+TxW3/ENfjEUWyVpB+8e51yAD/ewAe43L4bXYehVAKq+/CSfXEpYxU\n8kZv/mfA6nRfvOIA/iTx2uNw5NzC6TM5ZCBrXVxVGPmR9SwjnBHRmzVAmT8B\n=pY9e\n-----END PGP PUBLIC KEY BLOCK-----";

    @Test
    public void test() throws IOException {
        PGPPublicKeyRing cert = PGPainless.readKeyRing().publicKeyRing(REVOKED);
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)cert);
        Assertions.assertFalse((boolean)info.isUsableForSigning());
        Assertions.assertFalse((boolean)info.isUsableForEncryption());
    }
}

