/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.DocumentSignatureType;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.encryption_signing.EncryptionOptions;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.encryption_signing.SigningOptions;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnlockSecretKey;
import org.pgpainless.util.TestAllImplementations;

public class OnePassSignatureBracketingTest {
    @TestTemplate
    @ExtendWith(value={TestAllImplementations.class})
    public void onePassSignaturePacketsAndSignaturesAreBracketedTest() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        Object next;
        PGPSecretKeyRing key1 = PGPainless.generateKeyRing().modernKeyRing("Alice");
        PGPSecretKeyRing key2 = PGPainless.generateKeyRing().modernKeyRing("Bob");
        PGPPublicKeyRing cert1 = PGPainless.extractCertificate((PGPSecretKeyRing)key1);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        EncryptionStream encryptionStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)out).withOptions(ProducerOptions.signAndEncrypt((EncryptionOptions)EncryptionOptions.encryptCommunications().addRecipient(cert1), (SigningOptions)SigningOptions.get().addInlineSignature(SecretKeyRingProtector.unprotectedKeys(), key1, DocumentSignatureType.BINARY_DOCUMENT).addInlineSignature(SecretKeyRingProtector.unprotectedKeys(), key2, DocumentSignatureType.BINARY_DOCUMENT)).setAsciiArmor(true));
        ByteArrayInputStream data = new ByteArrayInputStream("Hello, World!".getBytes(StandardCharsets.UTF_8));
        Streams.pipeAll((InputStream)data, (OutputStream)encryptionStream);
        encryptionStream.close();
        ByteArrayInputStream ciphertextIn = new ByteArrayInputStream(out.toByteArray());
        InputStream inputStream = PGPUtil.getDecoderStream((InputStream)ciphertextIn);
        PGPObjectFactory objectFactory = ImplementationFactory.getInstance().getPGPObjectFactory(inputStream);
        PGPOnePassSignatureList onePassSignatures = null;
        PGPSignatureList signatures = null;
        block0: while ((next = objectFactory.nextObject()) != null) {
            if (next instanceof PGPEncryptedDataList) {
                PGPEncryptedDataList encryptedDataList = (PGPEncryptedDataList)next;
                for (PGPEncryptedData encryptedData : encryptedDataList) {
                    if (!(encryptedData instanceof PGPPublicKeyEncryptedData)) continue;
                    PGPPublicKeyEncryptedData publicKeyEncryptedData = (PGPPublicKeyEncryptedData)encryptedData;
                    PGPSecretKey secretKey = key1.getSecretKey(publicKeyEncryptedData.getKeyID());
                    PGPPrivateKey privateKey = UnlockSecretKey.unlockSecretKey((PGPSecretKey)secretKey, (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys());
                    PublicKeyDataDecryptorFactory decryptorFactory = ImplementationFactory.getInstance().getPublicKeyDataDecryptorFactory(privateKey);
                    InputStream decryptionStream = publicKeyEncryptedData.getDataStream(decryptorFactory);
                    objectFactory = ImplementationFactory.getInstance().getPGPObjectFactory(decryptionStream);
                    continue block0;
                }
                continue;
            }
            if (next instanceof PGPOnePassSignatureList) {
                onePassSignatures = (PGPOnePassSignatureList)next;
                continue;
            }
            if (next instanceof PGPCompressedData) {
                PGPCompressedData compressed = (PGPCompressedData)next;
                InputStream decompressor = compressed.getDataStream();
                objectFactory = ImplementationFactory.getInstance().getPGPObjectFactory(decompressor);
                continue;
            }
            if (next instanceof PGPLiteralData || !(next instanceof PGPSignatureList)) continue;
            signatures = (PGPSignatureList)next;
        }
        Assertions.assertNotNull(onePassSignatures);
        Assertions.assertNotNull(signatures);
        Assertions.assertEquals((int)signatures.size(), (int)onePassSignatures.size());
        Assertions.assertEquals((int)2, (int)signatures.size());
        for (int i = 0; i < signatures.size(); ++i) {
            PGPOnePassSignature onePassSignature = onePassSignatures.get(i);
            PGPSignature signature = signatures.get(signatures.size() - 1 - i);
            Assertions.assertEquals((long)onePassSignature.getKeyID(), (long)signature.getKeyID());
            byte[] encoded = onePassSignature.getEncoded();
            Assertions.assertEquals((int)3, (int)encoded[2]);
            Assertions.assertEquals((int)SignatureType.BINARY_DOCUMENT.getCode(), (int)encoded[3]);
            Assertions.assertEquals((int)HashAlgorithm.SHA512.getAlgorithmId(), (int)encoded[4]);
            Assertions.assertEquals((int)PublicKeyAlgorithm.EDDSA.getAlgorithmId(), (int)encoded[5]);
            boolean last = i == signatures.size() - 1;
            Assertions.assertEquals((int)(last ? 1 : 0), (int)encoded[14]);
        }
    }
}

