/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util.selection.keyring;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.key.TestKeys;
import org.pgpainless.util.selection.keyring.impl.Whitelist;

public class WhitelistKeyRingSelectionStrategyTest {
    @Test
    public void testWithPublicKeys() throws IOException {
        ConcurrentHashMap<String, Set<Long>> ids = new ConcurrentHashMap<String, Set<Long>>();
        ids.put("xmpp:juliet@capulet.lit", Collections.singleton(-5425419407118114754L));
        Whitelist.PubRingSelectionStrategy selectionStrategy = new Whitelist.PubRingSelectionStrategy(ids);
        PGPPublicKeyRing julietsKeys = TestKeys.getJulietPublicKeyRing();
        PGPPublicKeyRing romeosKeys = TestKeys.getRomeoPublicKeyRing();
        Assertions.assertTrue((boolean)selectionStrategy.accept((Object)"xmpp:juliet@capulet.lit", julietsKeys));
        Assertions.assertFalse((boolean)selectionStrategy.accept((Object)"xmpp:juliet@capulet.lit", romeosKeys));
        Assertions.assertFalse((boolean)selectionStrategy.accept((Object)"xmpp:romeo@montague.lit", julietsKeys));
    }

    @Test
    public void testWithSecretKeys() throws IOException, PGPException {
        ConcurrentHashMap<String, Set<Long>> ids = new ConcurrentHashMap<String, Set<Long>>();
        ids.put("xmpp:juliet@capulet.lit", Collections.singleton(-5425419407118114754L));
        Whitelist.SecRingSelectionStrategy selectionStrategy = new Whitelist.SecRingSelectionStrategy(ids);
        PGPSecretKeyRing julietsKeys = TestKeys.getJulietSecretKeyRing();
        PGPSecretKeyRing romeosKeys = TestKeys.getRomeoSecretKeyRing();
        Assertions.assertTrue((boolean)selectionStrategy.accept((Object)"xmpp:juliet@capulet.lit", julietsKeys));
        Assertions.assertFalse((boolean)selectionStrategy.accept((Object)"xmpp:juliet@capulet.lit", romeosKeys));
        Assertions.assertFalse((boolean)selectionStrategy.accept((Object)"xmpp:romeo@montague.lit", julietsKeys));
    }
}

