/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.algorithm;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum AEADAlgorithm {
    EAX(1, 16, 16),
    OCB(2, 15, 16),
    GCM(3, 12, 16);

    private final int algorithmId;
    private final int ivLength;
    private final int tagLength;
    private static final Map<Integer, AEADAlgorithm> MAP;

    private AEADAlgorithm(int id, int ivLength, int tagLength) {
        this.algorithmId = id;
        this.ivLength = ivLength;
        this.tagLength = tagLength;
    }

    public int getAlgorithmId() {
        return this.algorithmId;
    }

    public int getIvLength() {
        return this.ivLength;
    }

    public int getTagLength() {
        return this.tagLength;
    }

    @Nullable
    public static AEADAlgorithm fromId(int id) {
        return MAP.get(id);
    }

    @Nonnull
    public static AEADAlgorithm requireFromId(int id) {
        AEADAlgorithm algorithm = AEADAlgorithm.fromId(id);
        if (algorithm == null) {
            throw new NoSuchElementException("No AEADAlgorithm found for id " + id);
        }
        return algorithm;
    }

    static {
        MAP = new HashMap<Integer, AEADAlgorithm>();
        for (AEADAlgorithm h : AEADAlgorithm.values()) {
            MAP.put(h.algorithmId, h);
        }
    }
}

