/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.util;

import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class UserId
implements CharSequence {
    private final String name;
    private final String comment;
    private final String email;
    private long hash = Long.MAX_VALUE;

    private UserId(@Nullable String name, @Nullable String comment, @Nullable String email) {
        this.name = name == null ? null : name.trim();
        this.comment = comment == null ? null : comment.trim();
        this.email = email == null ? null : email.trim();
    }

    public static UserId onlyEmail(@Nonnull String email) {
        return new UserId(null, null, email);
    }

    public static UserId nameAndEmail(@Nonnull String name, @Nonnull String email) {
        return new UserId(name, null, email);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this.name, this.comment, this.email);
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public String getEmail() {
        return this.email;
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int i) {
        return this.toString().charAt(i);
    }

    @Override
    @Nonnull
    public CharSequence subSequence(int i, int i1) {
        return this.toString().subSequence(i, i1);
    }

    @Override
    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.name != null && !this.name.isEmpty()) {
            sb.append(this.name);
        }
        if (this.comment != null && !this.comment.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append('(').append(this.comment).append(')');
        }
        if (this.email != null && !this.email.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append('<').append(this.email).append('>');
        }
        return sb.toString();
    }

    @Deprecated
    public String asString() {
        return this.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserId)) {
            return false;
        }
        UserId other = (UserId)o;
        return UserId.isEqualComponent(this.name, other.name, false) && UserId.isEqualComponent(this.comment, other.comment, false) && UserId.isEqualComponent(this.email, other.email, true);
    }

    public int hashCode() {
        if (this.hash != Long.MAX_VALUE) {
            return (int)this.hash;
        }
        int hashCode = 7;
        hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
        hashCode = 31 * hashCode + (this.comment == null ? 0 : this.comment.hashCode());
        hashCode = 31 * hashCode + (this.email == null ? 0 : this.email.toLowerCase().hashCode());
        this.hash = hashCode;
        return hashCode;
    }

    private static boolean isEqualComponent(String value, String otherValue, boolean ignoreCase) {
        boolean otherValueIsNull;
        boolean valueIsNull = value == null;
        boolean bl = otherValueIsNull = otherValue == null;
        return valueIsNull && otherValueIsNull || !valueIsNull && !otherValueIsNull && (ignoreCase ? value.equalsIgnoreCase(otherValue) : value.equals(otherValue));
    }

    public static int compare(@Nullable UserId o1, @Nullable UserId o2, @Nonnull Comparator<UserId> comparator) {
        return comparator.compare(o1, o2);
    }

    private static class NullSafeStringComparator
    implements Comparator<String> {
        private NullSafeStringComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    }

    public static class DefaultIgnoreCaseComparator
    implements Comparator<UserId> {
        @Override
        public int compare(UserId o1, UserId o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            NullSafeStringComparator c = new NullSafeStringComparator();
            int cName = c.compare(DefaultIgnoreCaseComparator.lower(o1.getName()), DefaultIgnoreCaseComparator.lower(o2.getName()));
            if (cName != 0) {
                return cName;
            }
            int cComment = c.compare(DefaultIgnoreCaseComparator.lower(o1.getComment()), DefaultIgnoreCaseComparator.lower(o2.getComment()));
            if (cComment != 0) {
                return cComment;
            }
            return c.compare(DefaultIgnoreCaseComparator.lower(o1.getEmail()), DefaultIgnoreCaseComparator.lower(o2.getEmail()));
        }

        private static String lower(String string) {
            return string == null ? null : string.toLowerCase();
        }
    }

    public static class DefaultComparator
    implements Comparator<UserId> {
        @Override
        public int compare(UserId o1, UserId o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            NullSafeStringComparator c = new NullSafeStringComparator();
            int cName = c.compare(o1.getName(), o2.getName());
            if (cName != 0) {
                return cName;
            }
            int cComment = c.compare(o1.getComment(), o2.getComment());
            if (cComment != 0) {
                return cComment;
            }
            return c.compare(o1.getEmail(), o2.getEmail());
        }
    }

    public static final class Builder {
        private String name;
        private String comment;
        private String email;

        private Builder() {
        }

        private Builder(String name, String comment, String email) {
            this.name = name;
            this.comment = comment;
            this.email = email;
        }

        public Builder withName(@Nonnull String name) {
            this.name = name;
            return this;
        }

        public Builder withComment(@Nonnull String comment) {
            this.comment = comment;
            return this;
        }

        public Builder withEmail(@Nonnull String email) {
            this.email = email;
            return this;
        }

        public Builder noName() {
            this.name = null;
            return this;
        }

        public Builder noComment() {
            this.comment = null;
            return this;
        }

        public Builder noEmail() {
            this.email = null;
            return this;
        }

        public UserId build() {
            return new UserId(this.name, this.comment, this.email);
        }
    }
}

