/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.algorithm.HashAlgorithm;

public class AsciiArmorDashEscapeTest {
    @Test
    public void testDashEscapingInCleartextArmor() throws IOException {
        String withDash = "- This is a leading dash.\n";
        String dashEscaped = "-----BEGIN PGP SIGNED MESSAGE-----\nHash: SHA512\n\n- - This is a leading dash.\n";
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ArmoredOutputStream armor = new ArmoredOutputStream((OutputStream)out);
        armor.beginClearText(new int[]{HashAlgorithm.SHA512.getAlgorithmId()});
        armor.write(withDash.getBytes(StandardCharsets.UTF_8));
        armor.endClearText();
        armor.close();
        Assertions.assertArrayEquals((byte[])dashEscaped.getBytes(StandardCharsets.UTF_8), (byte[])out.toByteArray());
        ArmoredInputStream armorIn = new ArmoredInputStream((InputStream)new ByteArrayInputStream(out.toByteArray()));
        ByteArrayOutputStream plain = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)armorIn, (OutputStream)plain);
        Assertions.assertEquals((Object)withDash, (Object)plain.toString());
    }
}

