/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.util.Date;
import java.util.Iterator;
import org.junit.JUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.StreamEncoding;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.decryption_verification.MessageMetadata;
import org.pgpainless.util.DateUtil;

public class MessageMetadataTest {
    @Test
    public void processTestMessage_COMP_ENC_ENC_LIT() {
        MessageMetadata.Message message = new MessageMetadata.Message();
        MessageMetadata.CompressedData compressedData = new MessageMetadata.CompressedData(CompressionAlgorithm.ZIP, message.depth + 1);
        MessageMetadata.EncryptedData encryptedData = new MessageMetadata.EncryptedData(SymmetricKeyAlgorithm.AES_128, compressedData.depth + 1);
        MessageMetadata.EncryptedData encryptedData1 = new MessageMetadata.EncryptedData(SymmetricKeyAlgorithm.AES_256, encryptedData.depth + 1);
        MessageMetadata.LiteralData literalData = new MessageMetadata.LiteralData();
        message.setChild((MessageMetadata.Nested)compressedData);
        compressedData.setChild((MessageMetadata.Nested)encryptedData);
        encryptedData.setChild((MessageMetadata.Nested)encryptedData1);
        encryptedData1.setChild((MessageMetadata.Nested)literalData);
        MessageMetadata metadata = new MessageMetadata(message);
        Assertions.assertEquals((Object)SymmetricKeyAlgorithm.AES_128, (Object)metadata.getEncryptionAlgorithm(), (String)"getEncryptionAlgorithm() returns alg of outermost EncryptedData");
        Iterator encryptionAlgs = metadata.getEncryptionAlgorithms();
        Assertions.assertTrue((boolean)encryptionAlgs.hasNext(), (String)"There is at least one EncryptedData child");
        Assertions.assertTrue((boolean)encryptionAlgs.hasNext(), (String)"The child is still there");
        Assertions.assertEquals((Object)SymmetricKeyAlgorithm.AES_128, encryptionAlgs.next(), (String)"The first algo is AES128");
        Assertions.assertTrue((boolean)encryptionAlgs.hasNext(), (String)"There is another EncryptedData");
        Assertions.assertTrue((boolean)encryptionAlgs.hasNext(), (String)"There is *still* another EncryptedData");
        Assertions.assertEquals((Object)SymmetricKeyAlgorithm.AES_256, encryptionAlgs.next(), (String)"The second algo is AES256");
        Assertions.assertFalse((boolean)encryptionAlgs.hasNext(), (String)"There is no more EncryptedData");
        Assertions.assertFalse((boolean)encryptionAlgs.hasNext(), (String)"There *still* is no more EncryptedData");
        Assertions.assertEquals((Object)CompressionAlgorithm.ZIP, (Object)metadata.getCompressionAlgorithm(), (String)"getCompressionAlgorithm() returns alg of outermost CompressedData");
        Iterator compAlgs = metadata.getCompressionAlgorithms();
        Assertions.assertTrue((boolean)compAlgs.hasNext());
        Assertions.assertTrue((boolean)compAlgs.hasNext());
        Assertions.assertEquals((Object)CompressionAlgorithm.ZIP, compAlgs.next());
        Assertions.assertFalse((boolean)compAlgs.hasNext());
        Assertions.assertFalse((boolean)compAlgs.hasNext());
        Assertions.assertEquals((Object)"", (Object)metadata.getFilename());
        JUtils.assertDateEquals(new Date(0L), metadata.getModificationDate());
        Assertions.assertEquals((Object)StreamEncoding.BINARY, (Object)metadata.getLiteralDataEncoding());
    }

    @Test
    public void testProcessLiteralDataMessage() {
        MessageMetadata.LiteralData literalData = new MessageMetadata.LiteralData("collateral_murder.zip", DateUtil.parseUTCDate((String)"2010-04-05 10:12:03 UTC"), StreamEncoding.BINARY);
        MessageMetadata.Message message = new MessageMetadata.Message();
        message.setChild((MessageMetadata.Nested)literalData);
        MessageMetadata metadata = new MessageMetadata(message);
        Assertions.assertNull((Object)metadata.getCompressionAlgorithm());
        Assertions.assertNull((Object)metadata.getEncryptionAlgorithm());
        Assertions.assertEquals((Object)"collateral_murder.zip", (Object)metadata.getFilename());
        Assertions.assertEquals((Object)DateUtil.parseUTCDate((String)"2010-04-05 10:12:03 UTC"), (Object)metadata.getModificationDate());
        Assertions.assertEquals((Object)StreamEncoding.BINARY, (Object)metadata.getLiteralDataEncoding());
    }
}

