/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.util.io.Streams;
import org.junit.JUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.StreamEncoding;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.MessageMetadata;
import org.pgpainless.encryption_signing.EncryptionOptions;
import org.pgpainless.encryption_signing.EncryptionResult;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;

public class FileInformationTest {
    private static final String data = "Hello, World!\n";
    private static PGPSecretKeyRing secretKey;
    private static PGPPublicKeyRing certificate;

    @BeforeAll
    public static void generateKey() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        secretKey = PGPainless.generateKeyRing().modernKeyRing("alice@wonderland.lit");
        certificate = PGPainless.extractCertificate((PGPSecretKeyRing)secretKey);
    }

    @Test
    public void testTextFile() throws PGPException, IOException {
        String fileName = "message.txt";
        Date modificationDate = new Date();
        StreamEncoding encoding = StreamEncoding.TEXT;
        ByteArrayInputStream dataIn = new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8));
        ByteArrayOutputStream dataOut = new ByteArrayOutputStream();
        EncryptionStream encryptionStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)dataOut).withOptions(ProducerOptions.encrypt((EncryptionOptions)EncryptionOptions.encryptCommunications().addRecipient(certificate)).setFileName(fileName).setModificationDate(modificationDate).setEncoding(encoding));
        Streams.pipeAll((InputStream)dataIn, (OutputStream)encryptionStream);
        encryptionStream.close();
        EncryptionResult encResult = encryptionStream.getResult();
        Assertions.assertEquals((Object)fileName, (Object)encResult.getFileName());
        JUtils.assertDateEquals(modificationDate, encResult.getModificationDate());
        Assertions.assertEquals((Object)encoding, (Object)encResult.getFileEncoding());
        ByteArrayInputStream cryptIn = new ByteArrayInputStream(dataOut.toByteArray());
        ByteArrayOutputStream plainOut = new ByteArrayOutputStream();
        DecryptionStream decryptionStream = PGPainless.decryptAndOrVerify().onInputStream((InputStream)cryptIn).withOptions(new ConsumerOptions().addDecryptionKey(secretKey));
        Streams.pipeAll((InputStream)decryptionStream, (OutputStream)plainOut);
        decryptionStream.close();
        MessageMetadata decResult = decryptionStream.getMetadata();
        Assertions.assertEquals((Object)fileName, (Object)decResult.getFilename());
        JUtils.assertDateEquals(modificationDate, decResult.getModificationDate());
        Assertions.assertEquals((Object)encoding, (Object)decResult.getLiteralDataEncoding());
    }

    @Test
    public void testDefaults() throws PGPException, IOException {
        ByteArrayInputStream dataIn = new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8));
        ByteArrayOutputStream dataOut = new ByteArrayOutputStream();
        EncryptionStream encryptionStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)dataOut).withOptions(ProducerOptions.encrypt((EncryptionOptions)EncryptionOptions.encryptCommunications().addRecipient(certificate)));
        Streams.pipeAll((InputStream)dataIn, (OutputStream)encryptionStream);
        encryptionStream.close();
        EncryptionResult encResult = encryptionStream.getResult();
        Assertions.assertEquals((Object)"", (Object)encResult.getFileName());
        JUtils.assertDateEquals(PGPLiteralData.NOW, encResult.getModificationDate());
        Assertions.assertEquals((char)'b', (char)encResult.getFileEncoding().getCode());
        Assertions.assertFalse((boolean)encResult.isForYourEyesOnly());
        ByteArrayInputStream cryptIn = new ByteArrayInputStream(dataOut.toByteArray());
        ByteArrayOutputStream plainOut = new ByteArrayOutputStream();
        DecryptionStream decryptionStream = PGPainless.decryptAndOrVerify().onInputStream((InputStream)cryptIn).withOptions(new ConsumerOptions().addDecryptionKey(secretKey));
        Streams.pipeAll((InputStream)decryptionStream, (OutputStream)plainOut);
        decryptionStream.close();
        MessageMetadata decResult = decryptionStream.getMetadata();
        Assertions.assertEquals((Object)"", (Object)decResult.getFilename());
        JUtils.assertDateEquals(PGPLiteralData.NOW, decResult.getModificationDate());
        Assertions.assertEquals((char)'b', (char)decResult.getLiteralDataEncoding().getCode());
        Assertions.assertFalse((boolean)decResult.isForYourEyesOnly());
    }

    @Test
    public void testForYourEyesOnly() throws PGPException, IOException {
        ByteArrayInputStream dataIn = new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8));
        ByteArrayOutputStream dataOut = new ByteArrayOutputStream();
        EncryptionStream encryptionStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)dataOut).withOptions(ProducerOptions.encrypt((EncryptionOptions)EncryptionOptions.encryptCommunications().addRecipient(certificate)).setForYourEyesOnly());
        Streams.pipeAll((InputStream)dataIn, (OutputStream)encryptionStream);
        encryptionStream.close();
        EncryptionResult encResult = encryptionStream.getResult();
        Assertions.assertEquals((Object)"_CONSOLE", (Object)encResult.getFileName());
        JUtils.assertDateEquals(PGPLiteralData.NOW, encResult.getModificationDate());
        Assertions.assertEquals((char)'b', (char)encResult.getFileEncoding().getCode());
        Assertions.assertTrue((boolean)encResult.isForYourEyesOnly());
        ByteArrayInputStream cryptIn = new ByteArrayInputStream(dataOut.toByteArray());
        ByteArrayOutputStream plainOut = new ByteArrayOutputStream();
        DecryptionStream decryptionStream = PGPainless.decryptAndOrVerify().onInputStream((InputStream)cryptIn).withOptions(new ConsumerOptions().addDecryptionKey(secretKey));
        Streams.pipeAll((InputStream)decryptionStream, (OutputStream)plainOut);
        decryptionStream.close();
        MessageMetadata decResult = decryptionStream.getMetadata();
        Assertions.assertEquals((Object)"_CONSOLE", (Object)decResult.getFilename());
        JUtils.assertDateEquals(PGPLiteralData.NOW, decResult.getModificationDate());
        Assertions.assertEquals((char)'b', (char)decResult.getLiteralDataEncoding().getCode());
        Assertions.assertTrue((boolean)decResult.isForYourEyesOnly());
    }
}

