/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.DocumentSignatureType;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.encryption_signing.EncryptionOptions;
import org.pgpainless.encryption_signing.EncryptionResult;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.encryption_signing.SigningOptions;
import org.pgpainless.exception.KeyException;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.eddsa.EdDSACurve;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.util.MultiMap;
import org.pgpainless.util.Passphrase;
import org.pgpainless.util.TestAllImplementations;

public class SigningTest {
    @TestTemplate
    @ExtendWith(value={TestAllImplementations.class})
    public void testEncryptionAndSignatureVerification() throws IOException, PGPException {
        PGPPublicKeyRing julietKeys = TestKeys.getJulietPublicKeyRing();
        PGPPublicKeyRing romeoKeys = TestKeys.getRomeoPublicKeyRing();
        PGPSecretKeyRing cryptieKeys = TestKeys.getCryptieSecretKeyRing();
        KeyRingInfo cryptieInfo = new KeyRingInfo((PGPKeyRing)cryptieKeys);
        PGPSecretKey cryptieSigningKey = cryptieKeys.getSecretKey(((PGPPublicKey)cryptieInfo.getSigningSubkeys().get(0)).getKeyID());
        PGPPublicKeyRingCollection keys = new PGPPublicKeyRingCollection(Arrays.asList(julietKeys, romeoKeys));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        EncryptionStream encryptionStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)out).withOptions(ProducerOptions.signAndEncrypt((EncryptionOptions)EncryptionOptions.encryptDataAtRest().addRecipients((Iterable)keys).addRecipient(KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)cryptieKeys)), (SigningOptions)new SigningOptions().addInlineSignature(SecretKeyRingProtector.unlockSingleKeyWith((Passphrase)TestKeys.CRYPTIE_PASSPHRASE, (PGPSecretKey)cryptieSigningKey), cryptieKeys, "cryptie@encrypted.key", DocumentSignatureType.CANONICAL_TEXT_DOCUMENT)).setAsciiArmor(true));
        byte[] messageBytes = "This message is signed and encrypted to Romeo and Juliet.".getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream message = new ByteArrayInputStream(messageBytes);
        Streams.pipeAll((InputStream)message, (OutputStream)encryptionStream);
        encryptionStream.close();
        byte[] encrypted = out.toByteArray();
        ByteArrayInputStream cryptIn = new ByteArrayInputStream(encrypted);
        PGPSecretKeyRing romeoSecret = TestKeys.getRomeoSecretKeyRing();
        PGPSecretKeyRing julietSecret = TestKeys.getJulietSecretKeyRing();
        PGPSecretKeyRingCollection secretKeys = new PGPSecretKeyRingCollection(Arrays.asList(romeoSecret, julietSecret));
        PGPPublicKeyRingCollection verificationKeys = new PGPPublicKeyRingCollection(Arrays.asList(KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)cryptieKeys), romeoKeys));
        DecryptionStream decryptionStream = PGPainless.decryptAndOrVerify().onInputStream((InputStream)cryptIn).withOptions(new ConsumerOptions().addDecryptionKeys(secretKeys, SecretKeyRingProtector.unprotectedKeys()).addVerificationCerts(verificationKeys));
        ByteArrayOutputStream plaintextOut = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)decryptionStream, (OutputStream)plaintextOut);
        decryptionStream.close();
        OpenPgpMetadata metadata = decryptionStream.getResult();
        Assertions.assertTrue((boolean)metadata.isEncrypted());
        Assertions.assertTrue((boolean)metadata.isSigned());
        Assertions.assertTrue((boolean)metadata.isVerified());
        Assertions.assertTrue((boolean)metadata.containsVerifiedSignatureFrom(KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)cryptieKeys)));
        Assertions.assertFalse((boolean)metadata.containsVerifiedSignatureFrom(julietKeys));
    }

    @TestTemplate
    @ExtendWith(value={TestAllImplementations.class})
    public void testSignWithInvalidUserIdFails() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing("alice", "password123");
        SecretKeyRingProtector protector = SecretKeyRingProtector.unlockAnyKeyWith((Passphrase)Passphrase.fromPassword((String)"password123"));
        SigningOptions opts = new SigningOptions();
        Assertions.assertThrows(KeyException.UnboundUserIdException.class, () -> opts.addInlineSignature(protector, secretKeys, "bob", DocumentSignatureType.CANONICAL_TEXT_DOCUMENT));
    }

    @TestTemplate
    @ExtendWith(value={TestAllImplementations.class})
    public void testSignWithRevokedUserIdFails() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing("alice", "password123");
        SecretKeyRingProtector protector = SecretKeyRingProtector.unlockAnyKeyWith((Passphrase)Passphrase.fromPassword((String)"password123"));
        PGPSecretKeyRing fSecretKeys = secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).revokeUserId((CharSequence)"alice", protector).done();
        SigningOptions opts = new SigningOptions();
        Assertions.assertThrows(KeyException.UnboundUserIdException.class, () -> opts.addInlineSignature(protector, fSecretKeys, "alice", DocumentSignatureType.CANONICAL_TEXT_DOCUMENT));
    }

    @TestTemplate
    @ExtendWith(value={TestAllImplementations.class})
    public void signWithHashAlgorithmOverride() throws PGPException, IOException {
        PGPSecretKeyRing secretKeys = TestKeys.getEmilSecretKeyRing();
        SecretKeyRingProtector protector = SecretKeyRingProtector.unprotectedKeys();
        SigningOptions options = new SigningOptions();
        Assertions.assertNull((Object)options.getHashAlgorithmOverride());
        options.overrideHashAlgorithm(HashAlgorithm.SHA224);
        Assertions.assertEquals((Object)HashAlgorithm.SHA224, (Object)options.getHashAlgorithmOverride());
        options.addDetachedSignature(protector, secretKeys, DocumentSignatureType.BINARY_DOCUMENT);
        String data = "Hello, World!\n";
        EncryptionStream signer = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)new ByteArrayOutputStream()).withOptions(ProducerOptions.sign((SigningOptions)options));
        Streams.pipeAll((InputStream)new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8)), (OutputStream)signer);
        signer.close();
        EncryptionResult result = signer.getResult();
        MultiMap sigs = result.getDetachedSignatures();
        Assertions.assertEquals((int)1, (int)sigs.size());
        SubkeyIdentifier signingKey = (SubkeyIdentifier)sigs.keySet().iterator().next();
        Assertions.assertEquals((int)1, (int)sigs.get((Object)signingKey).size());
        PGPSignature signature = (PGPSignature)sigs.get((Object)signingKey).iterator().next();
        Assertions.assertEquals((int)HashAlgorithm.SHA224.getAlgorithmId(), (int)signature.getHashAlgorithm());
    }

    @TestTemplate
    @ExtendWith(value={TestAllImplementations.class})
    public void negotiateHashAlgorithmChoseFallbackIfEmptyPreferences() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        PGPSecretKeyRing secretKeys = ((KeyRingBuilder)PGPainless.buildKeyRing().setPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.EDDSA((EdDSACurve)EdDSACurve._Ed25519), (KeyFlag)KeyFlag.CERTIFY_OTHER, (KeyFlag[])new KeyFlag[]{KeyFlag.SIGN_DATA}).overridePreferredHashAlgorithms(new HashAlgorithm[0]))).addUserId("Alice").build();
        SigningOptions options = new SigningOptions().addDetachedSignature(SecretKeyRingProtector.unprotectedKeys(), secretKeys, DocumentSignatureType.BINARY_DOCUMENT);
        String data = "Hello, World!\n";
        EncryptionStream signer = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)new ByteArrayOutputStream()).withOptions(ProducerOptions.sign((SigningOptions)options));
        Streams.pipeAll((InputStream)new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8)), (OutputStream)signer);
        signer.close();
        EncryptionResult result = signer.getResult();
        MultiMap sigs = result.getDetachedSignatures();
        SubkeyIdentifier signingKey = (SubkeyIdentifier)sigs.keySet().iterator().next();
        PGPSignature signature = (PGPSignature)sigs.get((Object)signingKey).iterator().next();
        Assertions.assertEquals((int)PGPainless.getPolicy().getSignatureHashAlgorithmPolicy().defaultHashAlgorithm().getAlgorithmId(), (int)signature.getHashAlgorithm());
    }

    @TestTemplate
    @ExtendWith(value={TestAllImplementations.class})
    public void negotiateHashAlgorithmChoseFallbackIfUnacceptablePreferences() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        PGPSecretKeyRing secretKeys = ((KeyRingBuilder)PGPainless.buildKeyRing().setPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.EDDSA((EdDSACurve)EdDSACurve._Ed25519), (KeyFlag)KeyFlag.CERTIFY_OTHER, (KeyFlag[])new KeyFlag[]{KeyFlag.SIGN_DATA}).overridePreferredHashAlgorithms(new HashAlgorithm[]{HashAlgorithm.MD5}))).addUserId("Alice").build();
        SigningOptions options = new SigningOptions().addDetachedSignature(SecretKeyRingProtector.unprotectedKeys(), secretKeys, DocumentSignatureType.BINARY_DOCUMENT);
        String data = "Hello, World!\n";
        EncryptionStream signer = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)new ByteArrayOutputStream()).withOptions(ProducerOptions.sign((SigningOptions)options));
        Streams.pipeAll((InputStream)new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8)), (OutputStream)signer);
        signer.close();
        EncryptionResult result = signer.getResult();
        MultiMap sigs = result.getDetachedSignatures();
        SubkeyIdentifier signingKey = (SubkeyIdentifier)sigs.keySet().iterator().next();
        PGPSignature signature = (PGPSignature)sigs.get((Object)signingKey).iterator().next();
        Assertions.assertEquals((int)PGPainless.getPolicy().getSignatureHashAlgorithmPolicy().defaultHashAlgorithm().getAlgorithmId(), (int)signature.getHashAlgorithm());
    }

    @TestTemplate
    @ExtendWith(value={TestAllImplementations.class})
    public void signingWithNonCapableKeyThrowsKeyCannotSignException() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing secretKeys = ((KeyRingBuilder)PGPainless.buildKeyRing().setPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.EDDSA((EdDSACurve)EdDSACurve._Ed25519), (KeyFlag)KeyFlag.CERTIFY_OTHER, (KeyFlag[])new KeyFlag[0]))).addUserId("Alice").build();
        SigningOptions options = new SigningOptions();
        Assertions.assertThrows(KeyException.UnacceptableSigningKeyException.class, () -> options.addDetachedSignature(SecretKeyRingProtector.unprotectedKeys(), secretKeys, DocumentSignatureType.BINARY_DOCUMENT));
        Assertions.assertThrows(KeyException.UnacceptableSigningKeyException.class, () -> options.addInlineSignature(SecretKeyRingProtector.unprotectedKeys(), secretKeys, DocumentSignatureType.BINARY_DOCUMENT));
    }

    @TestTemplate
    @ExtendWith(value={TestAllImplementations.class})
    public void signWithInvalidUserIdThrowsKeyValidationError() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing secretKeys = ((KeyRingBuilder)PGPainless.buildKeyRing().setPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.EDDSA((EdDSACurve)EdDSACurve._Ed25519), (KeyFlag)KeyFlag.CERTIFY_OTHER, (KeyFlag[])new KeyFlag[]{KeyFlag.SIGN_DATA}))).addUserId("Alice").build();
        SigningOptions options = new SigningOptions();
        Assertions.assertThrows(KeyException.UnboundUserIdException.class, () -> options.addDetachedSignature(SecretKeyRingProtector.unprotectedKeys(), secretKeys, "Bob", DocumentSignatureType.BINARY_DOCUMENT));
        Assertions.assertThrows(KeyException.UnboundUserIdException.class, () -> options.addInlineSignature(SecretKeyRingProtector.unprotectedKeys(), secretKeys, "Bob", DocumentSignatureType.BINARY_DOCUMENT));
    }
}

