/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.parsing;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.util.ArmorUtils;

public class KeyRingCollectionReaderTest {
    @Test
    public void writeAndParseKeyRingCollections() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        PGPSecretKeyRing alice = PGPainless.generateKeyRing().modernKeyRing("Alice <alice@pgpainless.org>");
        PGPSecretKeyRing bob = PGPainless.generateKeyRing().modernKeyRing("Bob <bob@pgpainless.org>");
        PGPSecretKeyRingCollection collection = KeyRingUtils.keyRingsToKeyRingCollection((PGPSecretKeyRing[])new PGPSecretKeyRing[]{alice, bob});
        String ascii = ArmorUtils.toAsciiArmoredString((PGPSecretKeyRingCollection)collection);
        PGPSecretKeyRingCollection parsed = PGPainless.readKeyRing().secretKeyRingCollection(ascii);
        Assertions.assertEquals((int)collection.size(), (int)parsed.size());
        PGPPublicKeyRing pAlice = KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)alice);
        PGPPublicKeyRing pBob = KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)bob);
        PGPPublicKeyRingCollection pCollection = KeyRingUtils.keyRingsToKeyRingCollection((PGPPublicKeyRing[])new PGPPublicKeyRing[]{pAlice, pBob});
        ascii = ArmorUtils.toAsciiArmoredString((PGPPublicKeyRingCollection)pCollection);
        PGPPublicKeyRingCollection pParsed = PGPainless.readKeyRing().publicKeyRingCollection(ascii);
        Assertions.assertEquals((int)pCollection.size(), (int)pParsed.size());
    }

    @Test
    public void parseSeparatedSecretKeyRingCollection() throws PGPException, IOException {
        String ascii = "-----BEGIN PGP PRIVATE KEY BLOCK-----\nVersion: PGPainless\nComment: 58F2 0119 232F BBC0 B624  CCA7 7BED B6B3 2279 0657\nComment: Alice <alice@pgpainless.org>\n\nlFgEYLIldRYJKwYBBAHaRw8BAQdAv06tp4xghoxP/oDnIXuB//vH0RajTK7urjNn\n8YlYnucAAPsFAWLAW0c70rSktFw4CbtelRvtkcsGQkJVXXekRPcrGQ5jtBxBbGlj\nZSA8YWxpY2VAcGdwYWlubGVzcy5vcmc+iHgEExYKACAFAmCyJXUCGwEFFgIDAQAE\nCwkIBwUVCgkICwIeAQIZAQAKCRB77bazInkGV9XIAP9M1yDWCPta2hMoNlKj74Yo\nkQXSI0VQT3FFq4ZIre5n9QEAxJTiMs+vhnmWChXz2RXvoqP/NdSYWZ6TLnqUy1Tz\nJQ2cXQRgsiV1EgorBgEEAZdVAQUBAQdAMUoA28ic8ZfbCzw3z60T3kmQNWQqdTQs\nHuxEQPj2B24DAQgHAAD/SWLvXh81Ho+6dysWNd9/qmtx0vcF1NeBsRu/Z+noe7gR\nc4h1BBgWCgAdBQJgsiV1AhsMBRYCAwEABAsJCAcFFQoJCAsCHgEACgkQe+22syJ5\nBleuPwEAvzGxpoCl4cRWk6t+UZdCALMdnM050sf0jruryQhg8lkBANa3i54K5Eze\n2ah+1f5O8JLudv5t9NS1kERY2JpqVlAPnFgEYLIldRYJKwYBBAHaRw8BAQdAO0VF\nebLPMAYaxGl99jyLkQEJ4wNgdI1rBn3SDYnUq3kAAP4ugbF5XlRNHzxnSubS7Byf\nbF9gnmFt8eCQWdTM0FwUvREviNUEGBYKAH0FAmCyJXUCGwIFFgIDAQAECwkIBwUV\nCgkICwIeAV8gBBkWCgAGBQJgsiV1AAoJEOTg022wUXnBdqoA/1LjvNS65BieQ1uc\nl0kleh+K3rm4nFTs9dE39mbAI0k1AP9uHb4ucGunvqkq9x2nuFzCZHLoaBrzgi9S\nnGvLiHzLBgAKCRB77bazInkGV5S5AP433Ln47AHNr4u8Jo5aU5ML5f5KcxaOhQES\nSCBQ71BYWQEAlBFEhROHvJB2NCH695/zp5z5O6tmA0rLSQxZUTvyuQg=\n=Iwkd\n-----END PGP PRIVATE KEY BLOCK-----\n\n-----BEGIN PGP PRIVATE KEY BLOCK-----\nVersion: PGPainless\nComment: 88DD 9483 8B3D AB5B A07B  8F77 C852 EE0C 9502 F445\nComment: Bob <bob@pgpainless.org>\n\nlFgEYLIldRYJKwYBBAHaRw8BAQdAY9AtZCfF3C8fLJ81o9qVlK4h6vgT///jGX6A\nqg/LsF4AAQDM5uiSRDYQBNqA/DydySUNLfjMvI4Aa7ONYwLqGoOvQA+mtBhCb2Ig\nPGJvYkBwZ3BhaW5sZXNzLm9yZz6IeAQTFgoAIAUCYLIldQIbAQUWAgMBAAQLCQgH\nBRUKCQgLAh4BAhkBAAoJEMhS7gyVAvRFdPgBAN36fO2Oo7iXukCgzOVRxb2sE1Ay\n+pWE+Vpt2Y4NiUrVAQCKmD0hl3SIolJf+sFpInToqT7s1P34o4hYPozEDj1IBZxd\nBGCyJXUSCisGAQQBl1UBBQEBB0C48wzNDfxyS/vjXNDWj06C4TLiu9JizHP1SQzN\nvs2YNQMBCAcAAP95XEFiQHLBbmpwvZiSRCt7MjXe4ODk+LPY787YyGiImBNUiHUE\nGBYKAB0FAmCyJXUCGwwFFgIDAQAECwkIBwUVCgkICwIeAQAKCRDIUu4MlQL0RVX1\nAP0Y1E2XEZZSBjU6a3LDY7so5h/WKyj2wFhPNlYJMPyEwAD/YwUd7K3Iu2jnSRyQ\nYkMPpBlUiCzY1WsPrYIpsrlhsAicWARgsiV1FgkrBgEEAdpHDwEBB0D2w+nDeSk1\nX8sGbIDc0eajB0nYaGoZ61LGjmJRXyxn/QABANmdFE//RkuC9vq150kbIXzjrm54\nTJ/l3HLv2Vb9JV5oEhSI1QQYFgoAfQUCYLIldQIbAgUWAgMBAAQLCQgHBRUKCQgL\nAh4BXyAEGRYKAAYFAmCyJXUACgkQ9mL4hDfRd/aN9AEAnI2ssrPZwREpOcZsrYIe\nxSRFKc8n8RMDizHgnSyj3ZgBAPVceQEU78wnatz/x/Jbr2hE9Pj8IJK8fT96aXti\nCEEOAAoJEMhS7gyVAvRFw+0A/34n6qI1mJuXUNWdJd2yiGCKXLvVkwvpn2wQ5kaX\n9/m2AQCJC+MXorN3ro7aGtlz/81rtHREZftt2YH+pAy2OWq/BQ==\n=JB3F\n-----END PGP PRIVATE KEY BLOCK-----";
        PGPSecretKeyRingCollection collection = PGPainless.readKeyRing().secretKeyRingCollection(ascii);
        Assertions.assertEquals((int)2, (int)collection.size());
        Iterator iterator = collection.getKeyRings();
        Assertions.assertEquals((Object)new OpenPgpV4Fingerprint("58F2 0119 232F BBC0 B624  CCA7 7BED B6B3 2279 0657"), (Object)new OpenPgpV4Fingerprint((PGPSecretKeyRing)iterator.next()));
        Assertions.assertEquals((Object)new OpenPgpV4Fingerprint("88DD 9483 8B3D AB5B A07B  8F77 C852 EE0C 9502 F445"), (Object)new OpenPgpV4Fingerprint((PGPSecretKeyRing)iterator.next()));
    }

    @Test
    public void parseConcatenatedSecretKeyRingCollection() throws PGPException, IOException {
        String ascii = "-----BEGIN PGP PRIVATE KEY BLOCK-----\nVersion: BCPG v1.68\n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\n4xeis3eujtoa2XP/zWu0dERl+23Zgf6kDLY5ar8F\n=TTn+\n-----END PGP PRIVATE KEY BLOCK-----";
        PGPSecretKeyRingCollection collection = PGPainless.readKeyRing().secretKeyRingCollection(ascii);
        Assertions.assertEquals((int)2, (int)collection.size());
        Iterator iterator = collection.getKeyRings();
        Assertions.assertEquals((Object)new OpenPgpV4Fingerprint("58F2 0119 232F BBC0 B624  CCA7 7BED B6B3 2279 0657"), (Object)new OpenPgpV4Fingerprint((PGPSecretKeyRing)iterator.next()));
        Assertions.assertEquals((Object)new OpenPgpV4Fingerprint("88DD 9483 8B3D AB5B A07B  8F77 C852 EE0C 9502 F445"), (Object)new OpenPgpV4Fingerprint((PGPSecretKeyRing)iterator.next()));
    }
}

