/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.Random;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.MarkerPacket;

public class TestUtils {
    public static final String ALPHABET = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final Random RANDOM = new Random();

    public static int getNumberOfItemsInIterator(Iterator<?> iterator) {
        int num = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++num;
        }
        return num;
    }

    public static File createTempDirectory() throws IOException {
        String name = TestUtils.randomString(10);
        File dir = Files.createTempDirectory(name, new FileAttribute[0]).toFile();
        dir.deleteOnExit();
        return dir;
    }

    private static String randomString(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(ALPHABET.charAt(RANDOM.nextInt(ALPHABET.length())));
        }
        return sb.toString();
    }

    public static MarkerPacket getMarkerPacket() throws IOException {
        BCPGInputStream pgpIn = new BCPGInputStream((InputStream)new ByteArrayInputStream("PGP".getBytes(StandardCharsets.UTF_8)));
        MarkerPacket markerPacket = new MarkerPacket(pgpIn);
        pgpIn.close();
        return markerPacket;
    }
}

