/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.algorithm;

import java.util.NoSuchElementException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.algorithm.AEADAlgorithm;

public class AEADAlgorithmTest {
    @Test
    public void testEAXParameters() {
        AEADAlgorithm eax = AEADAlgorithm.EAX;
        Assertions.assertEquals((int)1, (int)eax.getAlgorithmId());
        Assertions.assertEquals((int)16, (int)eax.getIvLength());
        Assertions.assertEquals((int)16, (int)eax.getTagLength());
    }

    @Test
    public void testOCBParameters() {
        AEADAlgorithm ocb = AEADAlgorithm.OCB;
        Assertions.assertEquals((int)2, (int)ocb.getAlgorithmId());
        Assertions.assertEquals((int)15, (int)ocb.getIvLength());
        Assertions.assertEquals((int)16, (int)ocb.getTagLength());
    }

    @Test
    public void testGCMParameters() {
        AEADAlgorithm gcm = AEADAlgorithm.GCM;
        Assertions.assertEquals((int)3, (int)gcm.getAlgorithmId());
        Assertions.assertEquals((int)12, (int)gcm.getIvLength());
        Assertions.assertEquals((int)16, (int)gcm.getTagLength());
    }

    @Test
    public void testFromId() {
        Assertions.assertEquals((Object)AEADAlgorithm.EAX, (Object)AEADAlgorithm.requireFromId((int)1));
        Assertions.assertEquals((Object)AEADAlgorithm.OCB, (Object)AEADAlgorithm.requireFromId((int)2));
        Assertions.assertEquals((Object)AEADAlgorithm.GCM, (Object)AEADAlgorithm.requireFromId((int)3));
        Assertions.assertNull((Object)AEADAlgorithm.fromId((int)99));
        Assertions.assertThrows(NoSuchElementException.class, () -> AEADAlgorithm.requireFromId((int)99));
    }
}

