/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.EncryptionPurpose;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.MissingKeyPassphraseStrategy;
import org.pgpainless.encryption_signing.EncryptionOptions;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.exception.MissingPassphraseException;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.passphrase_provider.SecretKeyPassphraseProvider;
import org.pgpainless.util.Passphrase;

public class MissingPassphraseForDecryptionTest {
    private final String passphrase = "dragon123";
    private PGPSecretKeyRing secretKeys;
    private byte[] message;

    @BeforeEach
    public void setup() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        this.secretKeys = PGPainless.generateKeyRing().modernKeyRing("Test", "dragon123");
        PGPPublicKeyRing certificate = PGPainless.extractCertificate((PGPSecretKeyRing)this.secretKeys);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        EncryptionStream encryptionStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)out).withOptions(ProducerOptions.encrypt((EncryptionOptions)EncryptionOptions.encryptCommunications().addRecipient(certificate)));
        Streams.pipeAll((InputStream)new ByteArrayInputStream("Hey, what's up?".getBytes(StandardCharsets.UTF_8)), (OutputStream)encryptionStream);
        encryptionStream.close();
        this.message = out.toByteArray();
    }

    @Test
    public void invalidPostponedKeysStrategyTest() {
        SecretKeyPassphraseProvider callback = new SecretKeyPassphraseProvider(){

            public Passphrase getPassphraseFor(Long keyId) {
                Assertions.fail((String)"MUST NOT get called in if postponed key strategy is invalid.");
                return null;
            }

            public boolean hasPassphrase(Long keyId) {
                return true;
            }
        };
        ConsumerOptions options = new ConsumerOptions().setMissingKeyPassphraseStrategy(null).addDecryptionKey(this.secretKeys, (SecretKeyRingProtector)SecretKeyRingProtector.defaultSecretKeyRingProtector((SecretKeyPassphraseProvider)callback));
        Assertions.assertThrows(IllegalStateException.class, () -> PGPainless.decryptAndOrVerify().onInputStream((InputStream)new ByteArrayInputStream(this.message)).withOptions(options));
    }

    @Test
    public void interactiveStrategy() throws PGPException, IOException {
        SecretKeyPassphraseProvider callback = new SecretKeyPassphraseProvider(){

            public Passphrase getPassphraseFor(Long keyId) {
                return Passphrase.fromPassword((String)"dragon123");
            }

            public boolean hasPassphrase(Long keyId) {
                return true;
            }
        };
        ConsumerOptions options = new ConsumerOptions().setMissingKeyPassphraseStrategy(MissingKeyPassphraseStrategy.INTERACTIVE).addDecryptionKey(this.secretKeys, (SecretKeyRingProtector)SecretKeyRingProtector.defaultSecretKeyRingProtector((SecretKeyPassphraseProvider)callback));
        DecryptionStream decryptionStream = PGPainless.decryptAndOrVerify().onInputStream((InputStream)new ByteArrayInputStream(this.message)).withOptions(options);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)decryptionStream, (OutputStream)out);
        decryptionStream.close();
        Assertions.assertArrayEquals((byte[])"Hey, what's up?".getBytes(StandardCharsets.UTF_8), (byte[])out.toByteArray());
    }

    @Test
    public void throwExceptionStrategy() throws PGPException, IOException {
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)this.secretKeys);
        List encryptionKeys = info.getEncryptionSubkeys(EncryptionPurpose.ANY);
        SecretKeyPassphraseProvider callback = new SecretKeyPassphraseProvider(){

            public Passphrase getPassphraseFor(Long keyId) {
                Assertions.fail((String)"MUST NOT get called in non-interactive mode.");
                return null;
            }

            public boolean hasPassphrase(Long keyId) {
                return true;
            }
        };
        ConsumerOptions options = new ConsumerOptions().setMissingKeyPassphraseStrategy(MissingKeyPassphraseStrategy.THROW_EXCEPTION).addDecryptionKey(this.secretKeys, (SecretKeyRingProtector)SecretKeyRingProtector.defaultSecretKeyRingProtector((SecretKeyPassphraseProvider)callback));
        try {
            PGPainless.decryptAndOrVerify().onInputStream((InputStream)new ByteArrayInputStream(this.message)).withOptions(options);
            Assertions.fail((String)"Expected exception!");
        }
        catch (MissingPassphraseException e) {
            Assertions.assertFalse((boolean)e.getKeyIds().isEmpty());
            Assertions.assertEquals((int)encryptionKeys.size(), (int)e.getKeyIds().size());
            for (PGPPublicKey encryptionKey : encryptionKeys) {
                Assertions.assertTrue((boolean)e.getKeyIds().contains(new SubkeyIdentifier((PGPKeyRing)this.secretKeys, encryptionKey.getKeyID())));
            }
        }
    }
}

