/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.key.protection.UnlockSecretKey;
import org.pgpainless.policy.Policy;
import org.pgpainless.util.Passphrase;

public class WrongSignerUserIdTest {
    private static final String KEY = "-----BEGIN PGP PRIVATE KEY BLOCK-----\n   Comment: Alice's OpenPGP Transferable Secret Key\n   Comment: https://www.ietf.org/id/draft-bre-openpgp-samples-01.html\n\n   lFgEXEcE6RYJKwYBBAHaRw8BAQdArjWwk3FAqyiFbFBKT4TzXcVBqPTB3gmzlC/U\n   b7O1u10AAP9XBeW6lzGOLx7zHH9AsUDUTb2pggYGMzd0P3ulJ2AfvQ4RtCZBbGlj\n   ZSBMb3ZlbGFjZSA8YWxpY2VAb3BlbnBncC5leGFtcGxlPoiQBBMWCAA4AhsDBQsJ\n   CAcCBhUKCQgLAgQWAgMBAh4BAheAFiEE64W7X6M6deFelE5j8jFVDE9H444FAl2l\n   nzoACgkQ8jFVDE9H447pKwD6A5xwUqIDprBzrHfahrImaYEZzncqb25vkLV2arYf\n   a78A/R3AwtLQvjxwLDuzk4dUtUwvUYibL2sAHwj2kGaHnfICnF0EXEcE6RIKKwYB\n   BAGXVQEFAQEHQEL/BiGtq0k84Km1wqQw2DIikVYrQrMttN8d7BPfnr4iAwEIBwAA\n   /3/xFPG6U17rhTuq+07gmEvaFYKfxRB6sgAYiW6TMTpQEK6IeAQYFggAIBYhBOuF\n   u1+jOnXhXpROY/IxVQxPR+OOBQJcRwTpAhsMAAoJEPIxVQxPR+OOWdABAMUdSzpM\n   hzGs1O0RkWNQWbUzQ8nUOeD9wNbjE3zR+yfRAQDbYqvtWQKN4AQLTxVJN5X5AWyb\n   Pnn+We1aTBhaGa86AQ==\n   =n8OM\n   -----END PGP PRIVATE KEY BLOCK-----";
    private static final String USER_ID = "Alice Lovelace <alice@openpgp.example>";

    @Test
    public void verificationSucceedsWithDisabledCheck() throws PGPException, IOException {
        this.executeTest(false, true);
    }

    @Test
    public void verificationFailsWithEnabledCheck() throws PGPException, IOException {
        this.executeTest(true, false);
    }

    @AfterAll
    public static void resetDefault() {
        PGPainless.getPolicy().setSignerUserIdValidationLevel(Policy.SignerUserIdValidationLevel.DISABLED);
    }

    public void executeTest(boolean enableCheck, boolean expectSucessfulVerification) throws IOException, PGPException {
        PGPainless.getPolicy().setSignerUserIdValidationLevel(enableCheck ? Policy.SignerUserIdValidationLevel.STRICT : Policy.SignerUserIdValidationLevel.DISABLED);
        PGPSecretKeyRing secretKeys = PGPainless.readKeyRing().secretKeyRing(KEY);
        Assertions.assertEquals((Object)USER_ID, secretKeys.getPublicKey().getUserIDs().next());
        String messageWithWrongUserId = this.generateTestMessage(secretKeys);
        this.verifyTestMessage(messageWithWrongUserId, secretKeys, expectSucessfulVerification);
    }

    private void verifyTestMessage(String messageWithWrongUserId, PGPSecretKeyRing secretKeys, boolean expectSuccessfulVerification) throws IOException, PGPException {
        PGPPublicKeyRing certificate = PGPainless.extractCertificate((PGPSecretKeyRing)secretKeys);
        DecryptionStream decryptionStream = PGPainless.decryptAndOrVerify().onInputStream((InputStream)new ByteArrayInputStream(messageWithWrongUserId.getBytes(StandardCharsets.UTF_8))).withOptions(new ConsumerOptions().addDecryptionKey(secretKeys).addVerificationCert(certificate));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)decryptionStream, (OutputStream)out);
        decryptionStream.close();
        OpenPgpMetadata metadata = decryptionStream.getResult();
        if (expectSuccessfulVerification) {
            Assertions.assertTrue((boolean)metadata.isVerified());
        } else {
            Assertions.assertFalse((boolean)metadata.isVerified());
        }
    }

    private String generateTestMessage(PGPSecretKeyRing secretKeys) throws PGPException, IOException {
        int ch;
        PGPPublicKeyRing certificate = PGPainless.extractCertificate((PGPSecretKeyRing)secretKeys);
        Assertions.assertEquals((Object)USER_ID, certificate.getPublicKey().getUserIDs().next());
        Iterator keys = secretKeys.getSecretKeys();
        PGPSecretKey signingKey = (PGPSecretKey)keys.next();
        PGPSecretKey encryptionKey = (PGPSecretKey)keys.next();
        PGPPrivateKey signingPrivKey = UnlockSecretKey.unlockSecretKey((PGPSecretKey)signingKey, (Passphrase)Passphrase.emptyPassphrase());
        ByteArrayOutputStream cipherText = new ByteArrayOutputStream();
        ArmoredOutputStream armorOut = new ArmoredOutputStream((OutputStream)cipherText);
        BcPGPDataEncryptorBuilder dataEncryptorBuilder = new BcPGPDataEncryptorBuilder(9);
        dataEncryptorBuilder.setWithIntegrityPacket(true);
        PGPEncryptedDataGenerator encDataGenerator = new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)dataEncryptorBuilder);
        encDataGenerator.addMethod((PGPKeyEncryptionMethodGenerator)new BcPublicKeyKeyEncryptionMethodGenerator(encryptionKey.getPublicKey()));
        OutputStream encStream = encDataGenerator.open((OutputStream)armorOut, new byte[4096]);
        PGPCompressedDataGenerator compressedDataGenerator = new PGPCompressedDataGenerator(2);
        BCPGOutputStream bOut = new BCPGOutputStream(compressedDataGenerator.open(encStream));
        PGPSignatureGenerator sigGen = new PGPSignatureGenerator((PGPContentSignerBuilder)new BcPGPContentSignerBuilder(signingKey.getPublicKey().getAlgorithm(), HashAlgorithm.SHA512.getAlgorithmId()));
        sigGen.init(0, signingPrivKey);
        PGPSignatureSubpacketGenerator subpacketGenerator = new PGPSignatureSubpacketGenerator();
        subpacketGenerator.addSignerUserID(false, "Albert Lovelace <albert@openpgp.example>");
        sigGen.setHashedSubpackets(subpacketGenerator.generate());
        sigGen.generateOnePassVersion(false).encode((OutputStream)bOut);
        PGPLiteralDataGenerator literalDataGenerator = new PGPLiteralDataGenerator();
        OutputStream lOut = literalDataGenerator.open((OutputStream)bOut, 'b', "_CONSOLE", new Date(), new byte[4096]);
        ByteArrayInputStream msgIn = new ByteArrayInputStream("Hello, World!\n".getBytes(StandardCharsets.UTF_8));
        while ((ch = msgIn.read()) >= 0) {
            lOut.write(ch);
            sigGen.update((byte)ch);
        }
        lOut.close();
        sigGen.generate().encode((OutputStream)bOut);
        compressedDataGenerator.close();
        encStream.close();
        armorOut.close();
        return cipherText.toString();
    }
}

