/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.modification;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.pgpainless.PGPainless;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.PasswordBasedSecretKeyRingProtector;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;
import org.pgpainless.key.util.UserId;
import org.pgpainless.util.Passphrase;
import org.pgpainless.util.TestAllImplementations;

public class AddUserIdTest {
    @TestTemplate
    @ExtendWith(value={TestAllImplementations.class})
    public void addUserIdToExistingKeyRing() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().simpleEcKeyRing("alice@wonderland.lit", "rabb1th0le");
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Iterator userIds = info.getValidUserIds().iterator();
        Assertions.assertEquals((Object)"alice@wonderland.lit", userIds.next());
        Assertions.assertFalse((boolean)userIds.hasNext());
        PasswordBasedSecretKeyRingProtector protector = PasswordBasedSecretKeyRingProtector.forKey((PGPKeyRing)secretKeys, (Passphrase)Passphrase.fromPassword((String)"rabb1th0le"));
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).addUserId((CharSequence)"cheshirecat@wonderland.lit", (SecretKeyRingProtector)protector).done();
        info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        userIds = info.getValidUserIds().iterator();
        Assertions.assertEquals((Object)"alice@wonderland.lit", userIds.next());
        Assertions.assertEquals((Object)"cheshirecat@wonderland.lit", userIds.next());
        Assertions.assertFalse((boolean)userIds.hasNext());
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).revokeUserId((CharSequence)"cheshirecat@wonderland.lit", (SecretKeyRingProtector)protector).done();
        info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        userIds = info.getValidUserIds().iterator();
        Assertions.assertEquals((Object)"alice@wonderland.lit", userIds.next());
        Assertions.assertFalse((boolean)userIds.hasNext());
    }

    @TestTemplate
    @ExtendWith(value={TestAllImplementations.class})
    public void deleteUserId_noSuchElementExceptionForMissingUserId() throws IOException, PGPException {
        PGPSecretKeyRing secretKeys = TestKeys.getCryptieSecretKeyRing();
        Assertions.assertThrows(NoSuchElementException.class, () -> PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).revokeUserId((CharSequence)"invalid@user.id", (SecretKeyRingProtector)new UnprotectedKeysProtector()));
    }

    @TestTemplate
    @ExtendWith(value={TestAllImplementations.class})
    public void deleteExistingAndAddNewUserIdToExistingKeyRing() throws PGPException, IOException {
        String ARMORED_PRIVATE_KEY = "-----BEGIN PGP PRIVATE KEY BLOCK-----\r\n\r\nxVgEX6UIExYJKwYBBAHaRw8BAQdAMfHf64wPQ2LC9In5AKYU/KT1qWvI7e7a\r\nXr+LWeQGUKIAAQCcB3zZlHfepQT26LIwbTDn4lvQ9LuD1fk2hK6i9FXFxxO7\r\nzRI8dXNlckBleGFtcGxlLmNvbT7CjwQQFgoAIAUCX6UIEwYLCQcIAwIEFQgK\r\nAgQWAgEAAhkBAhsDAh4BACEJEEoCtcZ3snFuFiEENY1GQZqrKQqgUAXASgK1\r\nxneycW6P6AEA5iXFK+fWpj0vn3xpKEuFRqvytPKFzhwd4wEvL+IGSPEBALE/\r\npZdMzsDoKPENiLFpboDVNVJScwFXIleKmtNaRycFx10EX6UIExIKKwYBBAGX\r\nVQEFAQEHQBDdeawWVNqYkP8c/ihLEUlVpn8cQw7rmRc/sIhdAXhfAwEIBwAA\r\n/0Jy7IelcHDjxE3OzagEzSxNrCVw8uPHNRl8s6iP+CQYEfHCeAQYFggACQUC\r\nX6UIEwIbDAAhCRBKArXGd7JxbhYhBDWNRkGaqykKoFAFwEoCtcZ3snFuWp8B\r\nAIzRBYJSfZzlvlyyPhrbXJoYSICGNy/5x7noXjp/ByeOAQDnTbQi4XwXJrU4\r\nA8Nl9eyz16ZWUzEPwfWgahIG1eQDDA==\r\n=bk4o\r\n-----END PGP PRIVATE KEY BLOCK-----\r\n";
        PGPSecretKeyRing secretKeys = PGPainless.readKeyRing().secretKeyRing("-----BEGIN PGP PRIVATE KEY BLOCK-----\r\n\r\nxVgEX6UIExYJKwYBBAHaRw8BAQdAMfHf64wPQ2LC9In5AKYU/KT1qWvI7e7a\r\nXr+LWeQGUKIAAQCcB3zZlHfepQT26LIwbTDn4lvQ9LuD1fk2hK6i9FXFxxO7\r\nzRI8dXNlckBleGFtcGxlLmNvbT7CjwQQFgoAIAUCX6UIEwYLCQcIAwIEFQgK\r\nAgQWAgEAAhkBAhsDAh4BACEJEEoCtcZ3snFuFiEENY1GQZqrKQqgUAXASgK1\r\nxneycW6P6AEA5iXFK+fWpj0vn3xpKEuFRqvytPKFzhwd4wEvL+IGSPEBALE/\r\npZdMzsDoKPENiLFpboDVNVJScwFXIleKmtNaRycFx10EX6UIExIKKwYBBAGX\r\nVQEFAQEHQBDdeawWVNqYkP8c/ihLEUlVpn8cQw7rmRc/sIhdAXhfAwEIBwAA\r\n/0Jy7IelcHDjxE3OzagEzSxNrCVw8uPHNRl8s6iP+CQYEfHCeAQYFggACQUC\r\nX6UIEwIbDAAhCRBKArXGd7JxbhYhBDWNRkGaqykKoFAFwEoCtcZ3snFuWp8B\r\nAIzRBYJSfZzlvlyyPhrbXJoYSICGNy/5x7noXjp/ByeOAQDnTbQi4XwXJrU4\r\nA8Nl9eyz16ZWUzEPwfWgahIG1eQDDA==\r\n=bk4o\r\n-----END PGP PRIVATE KEY BLOCK-----\r\n");
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Iterator userIds = info.getValidUserIds().iterator();
        Assertions.assertEquals((Object)"<user@example.com>", userIds.next());
        Assertions.assertFalse((boolean)userIds.hasNext());
        UnprotectedKeysProtector protector = new UnprotectedKeysProtector();
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).revokeUserId((CharSequence)"<user@example.com>", (SecretKeyRingProtector)protector).addUserId((CharSequence)"cheshirecat@wonderland.lit", (SecretKeyRingProtector)protector).done();
        info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        userIds = info.getValidUserIds().iterator();
        Assertions.assertEquals((Object)"cheshirecat@wonderland.lit", userIds.next());
        Assertions.assertFalse((boolean)userIds.hasNext());
    }

    @Test
    public void addNewPrimaryUserIdTest() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing("Alice");
        UserId bob = UserId.newBuilder().withName("Bob").noEmail().noComment().build();
        Assertions.assertNotEquals((Object)"Bob", (Object)PGPainless.inspectKeyRing((PGPKeyRing)secretKeys).getPrimaryUserId());
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).addPrimaryUserId((CharSequence)bob, SecretKeyRingProtector.unprotectedKeys()).done();
        Assertions.assertEquals((Object)"Bob", (Object)PGPainless.inspectKeyRing((PGPKeyRing)secretKeys).getPrimaryUserId());
    }
}

