/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.protection;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.protection.passphrase_provider.MapBasedPassphraseProvider;
import org.pgpainless.util.Passphrase;

public class MapBasedPassphraseProviderTest {
    @Test
    public void testMapBasedProvider() throws IOException, PGPException {
        ConcurrentHashMap<Long, Passphrase> passphraseMap = new ConcurrentHashMap<Long, Passphrase>();
        passphraseMap.put(1L, Passphrase.fromPassword((String)"tiger"));
        passphraseMap.put(123123123L, Passphrase.fromPassword((String)"snake"));
        passphraseMap.put(69696969L, Passphrase.emptyPassphrase());
        MapBasedPassphraseProvider provider = new MapBasedPassphraseProvider(passphraseMap);
        Assertions.assertEquals((Object)Passphrase.fromPassword((String)"tiger"), (Object)provider.getPassphraseFor(Long.valueOf(1L)));
        Assertions.assertEquals((Object)Passphrase.fromPassword((String)"snake"), (Object)provider.getPassphraseFor(Long.valueOf(123123123L)));
        Assertions.assertEquals((Object)Passphrase.emptyPassphrase(), (Object)provider.getPassphraseFor(Long.valueOf(69696969L)));
        Assertions.assertNull((Object)provider.getPassphraseFor(Long.valueOf(555L)));
        PGPSecretKeyRing secretKeys = TestKeys.getCryptieSecretKeyRing();
        passphraseMap = new ConcurrentHashMap();
        passphraseMap.put(secretKeys.getSecretKey().getKeyID(), TestKeys.CRYPTIE_PASSPHRASE);
        provider = new MapBasedPassphraseProvider(passphraseMap);
        Assertions.assertEquals((Object)TestKeys.CRYPTIE_PASSPHRASE, (Object)provider.getPassphraseFor(secretKeys.getSecretKey()));
        Assertions.assertNull((Object)provider.getPassphraseFor(TestKeys.getEmilSecretKeyRing().getSecretKey()));
    }
}

