/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.util;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.Random;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVectorGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.ecc.EllipticCurve;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnlockSecretKey;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.util.CollectionUtils;

public class KeyRingUtilTest {
    @Test
    public void testInjectCertification() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing("Alice");
        Assertions.assertFalse((boolean)secretKeys.getPublicKey().getUserAttributes().hasNext());
        int sigCount = CollectionUtils.iteratorToList((Iterator)secretKeys.getPublicKey().getSignatures()).size();
        byte[] image = new byte[512];
        new Random().nextBytes(image);
        PGPUserAttributeSubpacketVectorGenerator userAttrGen = new PGPUserAttributeSubpacketVectorGenerator();
        userAttrGen.setImageAttribute(1, image);
        PGPUserAttributeSubpacketVector userAttr = userAttrGen.generate();
        PGPSignatureGenerator sigGen = new PGPSignatureGenerator(ImplementationFactory.getInstance().getPGPContentSignerBuilder(secretKeys.getPublicKey().getAlgorithm(), HashAlgorithm.SHA512.getAlgorithmId()));
        sigGen.init(SignatureType.POSITIVE_CERTIFICATION.getCode(), UnlockSecretKey.unlockSecretKey((PGPSecretKey)secretKeys.getSecretKey(), (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys()));
        PGPSignature signature = sigGen.generateCertification(userAttr, secretKeys.getPublicKey());
        secretKeys = (PGPSecretKeyRing)KeyRingUtils.injectCertification((PGPKeyRing)secretKeys, (PGPUserAttributeSubpacketVector)userAttr, (PGPSignature)signature);
        Assertions.assertTrue((boolean)secretKeys.getPublicKey().getUserAttributes().hasNext());
        Assertions.assertEquals((Object)userAttr, secretKeys.getPublicKey().getUserAttributes().next());
        Assertions.assertEquals((int)(sigCount + 1), (int)CollectionUtils.iteratorToList((Iterator)secretKeys.getPublicKey().getSignatures()).size());
    }

    @Test
    public void testKeysPlusPublicKey() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing("Alice");
        PGPPublicKeyRing publicKeys = PGPainless.extractCertificate((PGPSecretKeyRing)secretKeys);
        PGPKeyPair keyPair = KeyRingBuilder.generateKeyPair((KeySpec)KeySpec.getBuilder((KeyType)KeyType.ECDH((EllipticCurve)EllipticCurve._P256), (KeyFlag)KeyFlag.ENCRYPT_COMMS, (KeyFlag[])new KeyFlag[]{KeyFlag.ENCRYPT_STORAGE}).build());
        PGPPublicKey pubkey = keyPair.getPublicKey();
        Assertions.assertFalse((boolean)pubkey.isMasterKey());
        PGPSecretKeyRing secretKeysPlus = (PGPSecretKeyRing)KeyRingUtils.keysPlusPublicKey((PGPKeyRing)secretKeys, (PGPPublicKey)pubkey);
        Assertions.assertNotNull((Object)secretKeysPlus.getPublicKey(pubkey.getKeyID()));
        PGPPublicKeyRing publicKeysPlus = (PGPPublicKeyRing)KeyRingUtils.keysPlusPublicKey((PGPKeyRing)publicKeys, (PGPPublicKey)pubkey);
        Assertions.assertNotNull((Object)publicKeysPlus.getPublicKey(pubkey.getKeyID()));
    }
}

