/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification.syntax_check;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.decryption_verification.syntax_check.InputSymbol;
import org.pgpainless.decryption_verification.syntax_check.PDA;
import org.pgpainless.exception.MalformedOpenPgpMessageException;

public class PDATest {
    @Test
    public void testSimpleLiteralMessageIsValid() throws MalformedOpenPgpMessageException {
        PDA check = new PDA();
        check.next(InputSymbol.LiteralData);
        check.next(InputSymbol.EndOfSequence);
        Assertions.assertTrue((boolean)check.isValid());
    }

    @Test
    public void testSimpleOpsSignedMesssageIsValid() throws MalformedOpenPgpMessageException {
        PDA check = new PDA();
        check.next(InputSymbol.OnePassSignature);
        check.next(InputSymbol.LiteralData);
        check.next(InputSymbol.Signature);
        check.next(InputSymbol.EndOfSequence);
        Assertions.assertTrue((boolean)check.isValid());
    }

    @Test
    public void testSimplePrependSignedMessageIsValid() throws MalformedOpenPgpMessageException {
        PDA check = new PDA();
        check.next(InputSymbol.Signature);
        check.next(InputSymbol.LiteralData);
        check.next(InputSymbol.EndOfSequence);
        Assertions.assertTrue((boolean)check.isValid());
    }

    @Test
    public void testOPSSignedCompressedMessageIsValid() throws MalformedOpenPgpMessageException {
        PDA check = new PDA();
        check.next(InputSymbol.OnePassSignature);
        check.next(InputSymbol.CompressedData);
        check.next(InputSymbol.Signature);
        check.next(InputSymbol.EndOfSequence);
        Assertions.assertTrue((boolean)check.isValid());
    }

    @Test
    public void testOPSSignedEncryptedMessageIsValid() {
        PDA check = new PDA();
        check.next(InputSymbol.OnePassSignature);
        check.next(InputSymbol.EncryptedData);
        check.next(InputSymbol.Signature);
        check.next(InputSymbol.EndOfSequence);
        Assertions.assertTrue((boolean)check.isValid());
    }

    @Test
    public void anyInputAfterEOSIsNotValid() {
        PDA check = new PDA();
        check.next(InputSymbol.LiteralData);
        check.next(InputSymbol.EndOfSequence);
        Assertions.assertThrows(MalformedOpenPgpMessageException.class, () -> check.next(InputSymbol.Signature));
    }

    @Test
    public void testEncryptedMessageWithAppendedStandaloneSigIsNotValid() {
        PDA check = new PDA();
        check.next(InputSymbol.EncryptedData);
        Assertions.assertThrows(MalformedOpenPgpMessageException.class, () -> check.next(InputSymbol.Signature));
    }

    @Test
    public void testOPSSignedEncryptedMessageWithMissingSigIsNotValid() {
        PDA check = new PDA();
        check.next(InputSymbol.OnePassSignature);
        check.next(InputSymbol.EncryptedData);
        Assertions.assertThrows(MalformedOpenPgpMessageException.class, () -> check.next(InputSymbol.EndOfSequence));
    }

    @Test
    public void testTwoLiteralDataIsNotValid() {
        PDA check = new PDA();
        check.next(InputSymbol.LiteralData);
        Assertions.assertThrows(MalformedOpenPgpMessageException.class, () -> check.next(InputSymbol.LiteralData));
    }

    @Test
    public void testTrailingSigIsNotValid() {
        PDA check = new PDA();
        check.next(InputSymbol.LiteralData);
        Assertions.assertThrows(MalformedOpenPgpMessageException.class, () -> check.next(InputSymbol.Signature));
    }

    @Test
    public void testOPSAloneIsNotValid() {
        PDA check = new PDA();
        check.next(InputSymbol.OnePassSignature);
        Assertions.assertThrows(MalformedOpenPgpMessageException.class, () -> check.next(InputSymbol.EndOfSequence));
    }

    @Test
    public void testOPSLitWithMissingSigIsNotValid() {
        PDA check = new PDA();
        check.next(InputSymbol.OnePassSignature);
        check.next(InputSymbol.LiteralData);
        Assertions.assertThrows(MalformedOpenPgpMessageException.class, () -> check.next(InputSymbol.EndOfSequence));
    }

    @Test
    public void testCompressedMessageWithStandalongAppendedSigIsNotValid() {
        PDA check = new PDA();
        check.next(InputSymbol.CompressedData);
        Assertions.assertThrows(MalformedOpenPgpMessageException.class, () -> check.next(InputSymbol.Signature));
    }

    @Test
    public void testOPSCompressedDataWithMissingSigIsNotValid() {
        PDA check = new PDA();
        check.next(InputSymbol.OnePassSignature);
        check.next(InputSymbol.CompressedData);
        Assertions.assertThrows(MalformedOpenPgpMessageException.class, () -> check.next(InputSymbol.EndOfSequence));
    }

    @Test
    public void testCompressedMessageFollowedByTrailingLiteralDataIsNotValid() {
        PDA check = new PDA();
        check.next(InputSymbol.CompressedData);
        Assertions.assertThrows(MalformedOpenPgpMessageException.class, () -> check.next(InputSymbol.LiteralData));
    }

    @Test
    public void testOPSWithPrependedSigIsValid() {
        PDA check = new PDA();
        check.next(InputSymbol.Signature);
        check.next(InputSymbol.OnePassSignature);
        check.next(InputSymbol.LiteralData);
        check.next(InputSymbol.Signature);
        check.next(InputSymbol.EndOfSequence);
        Assertions.assertTrue((boolean)check.isValid());
    }

    @Test
    public void testPrependedSigInsideOPSSignedMessageIsValid() {
        PDA check = new PDA();
        check.next(InputSymbol.OnePassSignature);
        check.next(InputSymbol.Signature);
        check.next(InputSymbol.LiteralData);
        check.next(InputSymbol.Signature);
        check.next(InputSymbol.EndOfSequence);
        Assertions.assertTrue((boolean)check.isValid());
    }
}

