/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature.builder;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.EncryptionPurpose;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.signature.builder.SubkeyBindingSignatureBuilder;
import org.pgpainless.signature.subpackets.SelfSignatureSubpackets;

public class SubkeyAndPrimaryKeyBindingSignatureTest {
    @Test
    public void testRebindSubkey() throws PGPException, IOException {
        PGPSecretKeyRing secretKeys = TestKeys.getEmilSecretKeyRing();
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        PGPSecretKey primaryKey = secretKeys.getSecretKey();
        PGPPublicKey encryptionSubkey = (PGPPublicKey)info.getEncryptionSubkeys(EncryptionPurpose.ANY).get(0);
        Assertions.assertNotNull((Object)encryptionSubkey);
        Set hashAlgorithmSet = info.getPreferredHashAlgorithms(encryptionSubkey.getKeyID());
        Assertions.assertEquals(new HashSet<HashAlgorithm>(Arrays.asList(HashAlgorithm.SHA512, HashAlgorithm.SHA384, HashAlgorithm.SHA256, HashAlgorithm.SHA224)), (Object)hashAlgorithmSet);
        SubkeyBindingSignatureBuilder sbb = new SubkeyBindingSignatureBuilder(primaryKey, SecretKeyRingProtector.unprotectedKeys());
        sbb.applyCallback(new SelfSignatureSubpackets.Callback(){

            public void modifyHashedSubpackets(SelfSignatureSubpackets hashedSubpackets) {
                hashedSubpackets.setKeyFlags(new KeyFlag[]{KeyFlag.ENCRYPT_COMMS, KeyFlag.ENCRYPT_STORAGE});
                hashedSubpackets.setPreferredHashAlgorithms(new HashAlgorithm[]{HashAlgorithm.SHA512});
            }
        });
        PGPSignature binding = sbb.build(encryptionSubkey);
        secretKeys = (PGPSecretKeyRing)KeyRingUtils.injectCertification((PGPKeyRing)secretKeys, (PGPPublicKey)encryptionSubkey, (PGPSignature)binding);
        info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertEquals(Collections.singleton(HashAlgorithm.SHA512), (Object)info.getPreferredHashAlgorithms(encryptionSubkey.getKeyID()));
    }
}

